/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter;

import fr.opensagres.xdocreport.converter.IConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConverterTo {
    private final String to;
    private final Map<String, IConverter> converters;

    public ConverterTo(String to) {
        this.to = to;
        this.converters = new HashMap<String, IConverter>();
    }

    public String getTo() {
        return this.to;
    }

    public Collection<IConverter> getConvertersTo() {
        return this.converters.values();
    }

    public IConverter getConverter(String via) {
        return this.converters.get(via);
    }

    public IConverter getDefaultConverter() {
        IConverter defaultConverter = null;
        for (IConverter converter : this.getConvertersTo()) {
            if (converter.isDefault()) {
                return converter;
            }
            if (defaultConverter != null) continue;
            defaultConverter = converter;
        }
        return defaultConverter;
    }

    public void addConverter(String via, IConverter converter) {
        this.converters.put(via, converter);
    }

    public Collection<String> getVias() {
        return this.converters.keySet();
    }
}

