/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public abstract class AbstractIdentityEnumType
implements UserType,
ParameterizedType,
Serializable {
    private static final long serialVersionUID = -6625622185856547501L;
    private static final Log LOG = LogFactory.getLog(AbstractIdentityEnumType.class);
    private static TypeResolver typeResolver = new TypeResolver();
    public static final String ENUM_ID_ACCESSOR = "getId";
    public static final String PARAM_ENUM_CLASS = "enumClass";
    private static final Map<Class<? extends Enum<?>>, BidiEnumMap> ENUM_MAPPINGS = new HashMap();
    protected Class<? extends Enum<?>> enumClass;
    protected BidiEnumMap bidiMap;
    protected AbstractStandardBasicType<?> type;
    protected int[] sqlTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BidiEnumMap getBidiEnumMap(Class<? extends Enum<?>> cls) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        BidiEnumMap m = ENUM_MAPPINGS.get(cls);
        if (m == null) {
            Map<Class<? extends Enum<?>>, BidiEnumMap> map = ENUM_MAPPINGS;
            synchronized (map) {
                if (!ENUM_MAPPINGS.containsKey(cls)) {
                    m = new BidiEnumMap(cls);
                    ENUM_MAPPINGS.put(cls, m);
                } else {
                    m = ENUM_MAPPINGS.get(cls);
                }
            }
        }
        return m;
    }

    public static boolean supports(Class enumClass) {
        if (enumClass.isEnum()) {
            try {
                Method idAccessor = enumClass.getMethod(ENUM_ID_ACCESSOR, new Class[0]);
                int mods = idAccessor.getModifiers();
                if (Modifier.isPublic(mods) && !Modifier.isStatic(mods)) {
                    Class<?> returnType = idAccessor.getReturnType();
                    return returnType != null && typeResolver.basic(returnType.getName()) instanceof AbstractStandardBasicType;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setParameterValues(Properties properties) {
        try {
            this.enumClass = Thread.currentThread().getContextClassLoader().loadClass((String)properties.get(PARAM_ENUM_CLASS));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Building ID-mapping for Enum Class %s", this.enumClass.getName()));
            }
            this.bidiMap = AbstractIdentityEnumType.getBidiEnumMap(this.enumClass);
            this.type = (AbstractStandardBasicType)typeResolver.basic(this.bidiMap.keyType.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Mapped Basic Type is %s", this.type));
            }
            this.sqlTypes = this.type.sqlTypes(null);
        }
        catch (Exception e) {
            throw new MappingException("Error mapping Enum Class using IdentifierEnumType", (Throwable)e);
        }
    }

    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    public Class<?> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object o1, Object o2) throws HibernateException {
        return o1 == o2;
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object deepCopy(Object o) throws HibernateException {
        return o;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        return (Serializable)o;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object orig, Object target, Object owner) throws HibernateException {
        return orig;
    }

    private static class BidiEnumMap
    implements Serializable {
        private static final long serialVersionUID = 3325751131102095834L;
        private final Map enumToKey;
        private final Map keytoEnum;
        private Class keyType;

        private BidiEnumMap(Class<? extends Enum> enumClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object[] values;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Building Bidirectional Enum Map...", new Object[0]));
            }
            EnumMap<Enum, Object> enumToKey = new EnumMap<Enum, Object>(enumClass);
            HashMap<Object, Object> keytoEnum = new HashMap<Object, Object>();
            Method idAccessor = enumClass.getMethod(AbstractIdentityEnumType.ENUM_ID_ACCESSOR, new Class[0]);
            this.keyType = idAccessor.getReturnType();
            Method valuesAccessor = enumClass.getMethod("values", new Class[0]);
            for (Object value : values = (Object[])valuesAccessor.invoke(enumClass, new Object[0])) {
                Object id = idAccessor.invoke(value, new Object[0]);
                enumToKey.put((Enum)value, id);
                if (keytoEnum.containsKey(id)) {
                    LOG.warn((Object)String.format("Duplicate Enum ID '%s' detected for Enum %s!", id, enumClass.getName()));
                }
                keytoEnum.put(id, value);
            }
            this.enumToKey = Collections.unmodifiableMap(enumToKey);
            this.keytoEnum = Collections.unmodifiableMap(keytoEnum);
        }

        public Object getEnumValue(Object id) {
            return this.keytoEnum.get(id);
        }

        public Object getKey(Object enumValue) {
            return this.enumToKey.get(enumValue);
        }
    }
}

