/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.substitute;

import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.configuration.Configuration;
import org.docx4j.fonts.fop.fonts.substitute.FontQualifier;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitution;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutions;

public class FontSubstitutionsConfigurator {
    private Configuration cfg;

    public FontSubstitutionsConfigurator(Configuration cfg) {
        this.cfg = cfg;
    }

    private static FontQualifier getQualfierFromConfiguration(Configuration cfg) throws FOPException {
        String fontStyle;
        String fontFamily = cfg.getAttribute("font-family", null);
        if (fontFamily == null) {
            throw new FOPException("substitution qualifier must have a font-family");
        }
        FontQualifier qualifier = new FontQualifier();
        qualifier.setFontFamily(fontFamily);
        String fontWeight = cfg.getAttribute("font-weight", null);
        if (fontWeight != null) {
            qualifier.setFontWeight(fontWeight);
        }
        if ((fontStyle = cfg.getAttribute("font-style", null)) != null) {
            qualifier.setFontStyle(fontStyle);
        }
        return qualifier;
    }

    public void configure(FontSubstitutions substitutions) throws FOPException {
        Configuration[] substitutionCfgs;
        for (Configuration substitutionCfg : substitutionCfgs = this.cfg.getChildren("substitution")) {
            Configuration fromCfg = substitutionCfg.getChild("from", false);
            if (fromCfg == null) {
                throw new FOPException("'substitution' element without child 'from' element");
            }
            Configuration toCfg = substitutionCfg.getChild("to", false);
            if (fromCfg == null) {
                throw new FOPException("'substitution' element without child 'to' element");
            }
            FontQualifier fromQualifier = FontSubstitutionsConfigurator.getQualfierFromConfiguration(fromCfg);
            FontQualifier toQualifier = FontSubstitutionsConfigurator.getQualfierFromConfiguration(toCfg);
            FontSubstitution substitution = new FontSubstitution(fromQualifier, toQualifier);
            substitutions.add(substitution);
        }
    }
}

