/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.support;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.GormValidateable;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.grails.datastore.gorm.support.EventTriggerCaller;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.validation.ValidationException;
import org.grails.orm.hibernate.support.HibernateVersionSupport;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Errors;

public class ClosureEventListener
implements SaveOrUpdateEventListener,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger(ClosureEventListener.class);
    final EventTriggerCaller saveOrUpdateCaller;
    final EventTriggerCaller beforeInsertCaller;
    final EventTriggerCaller preLoadEventCaller;
    final EventTriggerCaller postLoadEventListener;
    final EventTriggerCaller postInsertEventListener;
    final EventTriggerCaller postUpdateEventListener;
    final EventTriggerCaller postDeleteEventListener;
    final EventTriggerCaller preDeleteEventListener;
    final EventTriggerCaller preUpdateEventListener;
    final BeforeValidateHelper.BeforeValidateEventTriggerCaller beforeValidateEventListener;
    final PersistentEntity persistentEntity;
    final MetaClass domainMetaClass;
    final boolean isMultiTenant;
    final boolean failOnErrorEnabled;
    final Map validateParams;
    private Field actionQueueUpdatesField;
    private Field entityUpdateActionStateField;

    public ClosureEventListener(PersistentEntity persistentEntity, boolean failOnError, List failOnErrorPackages) {
        this.persistentEntity = persistentEntity;
        Class domainClazz = persistentEntity.getJavaClass();
        this.domainMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(domainClazz);
        this.isMultiTenant = ClassUtils.isMultiTenant((Class)domainClazz);
        this.saveOrUpdateCaller = this.buildCaller("onSave", domainClazz);
        this.beforeInsertCaller = this.buildCaller("beforeInsert", domainClazz);
        EventTriggerCaller preLoadEventCaller = this.buildCaller("onLoad", domainClazz);
        this.preLoadEventCaller = preLoadEventCaller == null ? this.buildCaller("beforeLoad", domainClazz) : preLoadEventCaller;
        this.postLoadEventListener = this.buildCaller("afterLoad", domainClazz);
        this.postInsertEventListener = this.buildCaller("afterInsert", domainClazz);
        this.postUpdateEventListener = this.buildCaller("afterUpdate", domainClazz);
        this.postDeleteEventListener = this.buildCaller("afterDelete", domainClazz);
        this.preDeleteEventListener = this.buildCaller("beforeDelete", domainClazz);
        this.preUpdateEventListener = this.buildCaller("beforeUpdate", domainClazz);
        this.beforeValidateEventListener = new BeforeValidateHelper.BeforeValidateEventTriggerCaller(domainClazz, this.domainMetaClass);
        this.failOnErrorEnabled = failOnErrorPackages.size() > 0 ? ClassUtils.isClassBelowPackage((Class)domainClazz, (List)failOnErrorPackages) : failOnError;
        this.validateParams = new HashMap();
        this.validateParams.put("deepValidate", Boolean.FALSE);
        try {
            this.actionQueueUpdatesField = ReflectionUtils.findField(ActionQueue.class, (String)"updates");
            this.actionQueueUpdatesField.setAccessible(true);
            this.entityUpdateActionStateField = ReflectionUtils.findField(EntityUpdateAction.class, (String)"state");
            this.entityUpdateActionStateField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
    }

    public void onPreLoad(final PreLoadEvent event) {
        if (this.preLoadEventCaller == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.preLoadEventCaller.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostLoad(final PostLoadEvent event) {
        if (this.postLoadEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postLoadEventListener.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostInsert(PostInsertEvent event) {
        final Object entity = event.getEntity();
        if (this.postInsertEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postInsertEventListener.call(entity);
                return null;
            }
        });
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        final Object entity = event.getEntity();
        if (this.postUpdateEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postUpdateEventListener.call(entity);
                return null;
            }
        });
    }

    public void onPostDelete(PostDeleteEvent event) {
        final Object entity = event.getEntity();
        if (this.postDeleteEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postDeleteEventListener.call(entity);
                return null;
            }
        });
    }

    public boolean onPreDelete(final PreDeleteEvent event) {
        if (this.preDeleteEventListener == null) {
            return false;
        }
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                return ClosureEventListener.this.preDeleteEventListener.call(event.getEntity());
            }
        });
    }

    public boolean onPreUpdate(final PreUpdateEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean evict = false;
                if (ClosureEventListener.this.preUpdateEventListener != null && !(evict = ClosureEventListener.this.preUpdateEventListener.call(entity))) {
                    ClosureEventListener.this.synchronizePersisterState((AbstractPreDatabaseOperationEvent)event, event.getState());
                }
                return evict || ClosureEventListener.this.doValidate(entity);
            }
        });
    }

    public boolean onPreInsert(final PreInsertEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean synchronizeState = false;
                if (ClosureEventListener.this.beforeInsertCaller != null) {
                    if (ClosureEventListener.this.beforeInsertCaller.call(entity)) {
                        return true;
                    }
                    synchronizeState = true;
                }
                if (synchronizeState) {
                    ClosureEventListener.this.synchronizePersisterState((AbstractPreDatabaseOperationEvent)event, event.getState());
                }
                return ClosureEventListener.this.doValidate(entity);
            }
        });
    }

    public void onValidate(ValidationEvent event) {
        this.beforeValidateEventListener.call(event.getEntityObject(), event.getValidatedFields());
    }

    protected boolean doValidate(Object entity) {
        boolean evict = false;
        GormValidateable validateable = (GormValidateable)entity;
        if (!validateable.shouldSkipValidation() && !validateable.validate(this.validateParams)) {
            evict = true;
            if (this.failOnErrorEnabled) {
                Errors errors = validateable.getErrors();
                throw ValidationException.newInstance((String)("Validation error whilst flushing entity [" + entity.getClass().getName() + "]"), (Errors)errors);
            }
        }
        return evict;
    }

    private EventTriggerCaller buildCaller(String eventName, Class<?> domainClazz) {
        return EventTriggerCaller.buildCaller((String)eventName, domainClazz, (MetaClass)this.domainMetaClass, null);
    }

    private void synchronizePersisterState(AbstractPreDatabaseOperationEvent event, Object[] state) {
        EntityPersister persister = event.getPersister();
        this.synchronizePersisterState(event, state, persister, persister.getPropertyNames());
    }

    private void synchronizePersisterState(AbstractPreDatabaseOperationEvent event, Object[] state, EntityPersister persister, String[] propertyNames) {
        Object entity = event.getEntity();
        EntityReflector reflector = this.persistentEntity.getReflector();
        HashMap<Integer, Object> changedState = new HashMap<Integer, Object>();
        EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            PersistentProperty property;
            String p = propertyNames[i];
            Integer index = entityMetamodel.getPropertyIndexOrNull(p);
            if (index == null || (property = this.persistentEntity.getPropertyByName(p)) == null || "version".equals(propertyName = property.getName())) continue;
            Object value = reflector.getProperty(entity, propertyName);
            if (state[index] != value) {
                changedState.put(i, value);
            }
            state[index.intValue()] = value;
        }
        this.synchronizeEntityUpdateActionState(event, entity, changedState);
    }

    private void synchronizeEntityUpdateActionState(AbstractPreDatabaseOperationEvent event, Object entity, HashMap<Integer, Object> changedState) {
        if (this.actionQueueUpdatesField != null && event instanceof PreInsertEvent && changedState.size() > 0) {
            try {
                ExecutableList updates = (ExecutableList)this.actionQueueUpdatesField.get(event.getSession().getActionQueue());
                if (updates != null) {
                    for (EntityUpdateAction updateAction : updates) {
                        Object[] updateState;
                        if (updateAction.getInstance() != entity || (updateState = (Object[])this.entityUpdateActionStateField.get(updateAction)) == null) continue;
                        for (Map.Entry<Integer, Object> entry : changedState.entrySet()) {
                            updateState[entry.getKey().intValue()] = entry.getValue();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error synchronizing object state with Hibernate: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithManualSession(AbstractEvent event, Closure<T> callable) {
        EventSource session = event.getSession();
        FlushMode current = HibernateVersionSupport.getFlushMode((Session)session);
        try {
            session.setFlushMode(FlushMode.MANUAL);
            Object object = callable.call();
            return (T)object;
        }
        finally {
            session.setFlushMode(current);
        }
    }
}

