/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ParameterWriter {
    private static final byte[] BINARY_INTRODUCER = new byte[]{95, 98, 105, 110, 97, 114, 121, 32, 39};
    public static final byte QUOTE = 39;

    private static void writeBytesEscaped(OutputStream out, byte[] bytes, int count, boolean noBackslashEscapes) throws IOException {
        if (noBackslashEscapes) {
            for (int i = 0; i < count; ++i) {
                if (39 == bytes[i]) {
                    out.write(39);
                }
                out.write(bytes[i]);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                    out.write(92);
                }
                out.write(bytes[i]);
            }
        }
    }

    private static void writeBytesEscapedUnsafe(PacketOutputStream out, byte[] bytes, int count, boolean noBackslashEscapes) {
        if (noBackslashEscapes) {
            for (int i = 0; i < count; ++i) {
                if (39 == bytes[i]) {
                    out.writeUnsafe(39);
                }
                out.writeUnsafe(bytes[i]);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                    out.writeUnsafe(92);
                }
                out.writeUnsafe(bytes[i]);
            }
        }
    }

    public static void write(OutputStream out, byte[] bytes, boolean noBackslashEscapes) throws IOException {
        out.write(BINARY_INTRODUCER);
        ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
        out.write(39);
    }

    public static void write(PacketOutputStream out, String value, boolean noBackslashEscapes) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        out.write(39);
        ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
        out.write(39);
    }

    public static void write(OutputStream out, InputStream is, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(39);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
        }
        out.write(39);
    }

    public static void write(OutputStream out, InputStream is, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int bytesToRead;
        out.write(39);
        byte[] buffer = new byte[1024];
        long bytesLeft = length;
        while ((bytesToRead = (int)Math.min(bytesLeft, (long)buffer.length)) != 0 && (len = is.read(buffer, 0, bytesToRead)) > 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
            bytesLeft -= (long)len;
        }
        out.write(39);
    }

    public static void write(OutputStream out, Reader reader, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(39);
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes("UTF-8");
            ParameterWriter.writeBytesEscaped(out, data, data.length, noBackslashEscapes);
        }
        out.write(39);
    }

    public static void write(OutputStream out, Reader reader, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int charsToRead;
        out.write(39);
        char[] buffer = new char[1024];
        long charsLeft = length;
        while ((charsToRead = (int)Math.min(charsLeft, (long)buffer.length)) != 0 && (len = reader.read(buffer, 0, charsToRead)) > 0) {
            byte[] bytes = new String(buffer, 0, len).getBytes("UTF-8");
            ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
            charsLeft -= (long)len;
        }
        out.write(39);
    }

    public static void write(PacketOutputStream out, int value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void write(PacketOutputStream out, long value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void write(PacketOutputStream out, double value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void writeUnsafe(PacketOutputStream out, Reader reader, boolean noBackslashEscapes) throws IOException {
        int len;
        out.writeUnsafe(39);
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes("UTF-8");
            ParameterWriter.writeBytesEscaped(out, data, data.length, noBackslashEscapes);
        }
        out.writeUnsafe(39);
    }

    public static void writeUnsafe(PacketOutputStream out, ArrayList<char[]> readArrays, boolean noBackslashEscapes) throws IOException {
        out.writeUnsafe(39);
        for (char[] charArray : readArrays) {
            byte[] data = new String(charArray, 0, charArray.length).getBytes("UTF-8");
            ParameterWriter.writeBytesEscapedUnsafe(out, data, data.length, noBackslashEscapes);
        }
        out.writeUnsafe(39);
    }

    public static void writeUnsafe(PacketOutputStream out, InputStream is, boolean noBackslashEscapes) throws IOException {
        int len;
        out.writeUnsafe(39);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscapedUnsafe(out, buffer, len, noBackslashEscapes);
        }
        out.writeUnsafe(39);
    }

    public static void writeUnsafe(PacketOutputStream out, String value, boolean noBackslashEscapes) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        out.writeUnsafe(39);
        ParameterWriter.writeBytesEscapedUnsafe(out, bytes, bytes.length, noBackslashEscapes);
        out.writeUnsafe(39);
    }

    public static void writeUnsafe(PacketOutputStream out, InputStream is, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int bytesToRead;
        out.writeUnsafe(39);
        byte[] buffer = new byte[1024];
        long bytesLeft = length;
        while ((bytesToRead = (int)Math.min(bytesLeft, (long)buffer.length)) != 0 && (len = is.read(buffer, 0, bytesToRead)) > 0) {
            ParameterWriter.writeBytesEscapedUnsafe(out, buffer, len, noBackslashEscapes);
            bytesLeft -= (long)len;
        }
        out.writeUnsafe(39);
    }

    public static void writeUnsafe(PacketOutputStream out, byte[] bytes, boolean noBackslashEscapes) {
        out.writeUnsafe(BINARY_INTRODUCER);
        ParameterWriter.writeBytesEscapedUnsafe(out, bytes, bytes.length, noBackslashEscapes);
        out.writeUnsafe(39);
    }

    static void formatMicroseconds(PacketOutputStream out, int microseconds, boolean writeFractionalSeconds) {
        if (microseconds == 0 || !writeFractionalSeconds) {
            return;
        }
        out.write(46);
        int factor = 100000;
        while (microseconds > 0) {
            int dig = microseconds / factor;
            out.write(48 + dig);
            microseconds -= dig * factor;
            factor /= 10;
        }
    }

    static void formatMicrosecondsUnsafe(PacketOutputStream out, int microseconds, boolean writeFractionalSeconds) {
        if (microseconds == 0 || !writeFractionalSeconds) {
            return;
        }
        out.buffer.put((byte)46);
        int factor = 100000;
        while (microseconds > 0) {
            int dig = microseconds / factor;
            out.buffer.put((byte)(48 + dig));
            microseconds -= dig * factor;
            factor /= 10;
        }
    }
}

