/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.html.SdtTagHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.SdtPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class TagSingleBox
extends SdtTagHandler {
    private static Logger log = LoggerFactory.getLogger(TagSingleBox.class);

    private Element createDiv(Document document, DocumentFragment docfrag, Node n) throws ParserConfigurationException, IOException, SAXException, JAXBException {
        Element xhtmlDiv = document.createElement("div");
        xhtmlDiv.setAttribute("style", ((Element)n).getAttribute("style"));
        docfrag.appendChild(xhtmlDiv);
        return xhtmlDiv;
    }

    private Node getNodeByName(String name, Node n) {
        if (n.getNodeType() != 1 && n.getNodeType() != 9) {
            return null;
        }
        if (n.getNodeName().equals(name)) {
            return n;
        }
        NodeList list = n.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = this.getNodeByName(name, list.item(i));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
        try {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            DocumentFragment docfrag = document.createDocumentFragment();
            Node contents = childResults.nextNode();
            Node firstP = this.getNodeByName("p", contents);
            Element xhtmlDiv = this.createDiv(document, docfrag, firstP);
            return this.attachContents(docfrag, (Node)xhtmlDiv, contents);
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    @Override
    public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
        try {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            DocumentFragment docfrag = document.createDocumentFragment();
            Node contents = resultSoFar;
            Node firstP = this.getNodeByName("p", contents);
            Element xhtmlDiv = this.createDiv(document, docfrag, firstP);
            return this.attachContents(docfrag, (Node)xhtmlDiv, contents);
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }
}

