/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext;

import com.datical.liquibase.ext.SqlPlusRunner;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class OracleSqlPlusExecutor
extends JdbcExecutor {
    private Logger log = LogService.getLog(this.getClass());
    private ChangeSet changeSet;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_UNABLE_TO_VALIDATE_CHANGE_SET = coreBundle.getString("unable.to.validate.changeset");
    protected static final String MSG_UNABLE_TO_VALIDATE_LICENSE = coreBundle.getString("no.executor.pro.license.found");

    @Override
    public String getName() {
        return "sqlplus";
    }

    @Override
    public int getPriority() {
        return 101;
    }

    @Override
    public ValidationErrors validate(ChangeSet changeSet) {
        if (changeSet.getRunWith() == null || changeSet.getRunWith().isEmpty()) {
            return new ValidationErrors();
        }
        ValidationErrors validationErrors = new ValidationErrors();
        if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
            String string = String.format(MSG_UNABLE_TO_VALIDATE_LICENSE, this.getName());
            validationErrors.addError(string);
            return validationErrors;
        }
        for (Change change : changeSet.getChanges()) {
            this.validateChange(changeSet, validationErrors, change, "");
        }
        if (changeSet.getRollback() != null) {
            for (Change change : changeSet.getRollback().getChanges()) {
                this.validateChange(changeSet, validationErrors, change, "rollback");
            }
        }
        this.changeSet = changeSet;
        return validationErrors;
    }

    private void validateChange(ChangeSet object, ValidationErrors validationErrors, Change change, String string) {
        if (!(change instanceof SQLFileChange) && !(change instanceof RawSQLChange)) {
            object = "In change set '" + ((ChangeSet)object).getId() + "::" + ((ChangeSet)object).getAuthor() + "' there is an unsupported change type '" + change.toString() + "'";
            object = String.format(MSG_UNABLE_TO_VALIDATE_CHANGE_SET, object, string, "sqlplus");
            validationErrors.addError((String)object);
        }
    }

    @Override
    public void modifyChangeSet(ChangeSet object) {
        List<Change> list = ((ChangeSet)object).getChanges();
        this.modifyChanges(list);
        if (((ChangeSet)object).getRollback() == null) {
            return;
        }
        object = ((ChangeSet)object).getRollback().getChanges();
        this.modifyChanges((List<Change>)object);
    }

    private void modifyChanges(List<Change> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Change change = (Change)object.next();
            if (!(change instanceof AbstractSQLChange) || ((AbstractSQLChange)change).isSplitStatementsSet()) continue;
            ((AbstractSQLChange)change).setSplitStatements(Boolean.FALSE);
        }
    }

    @Override
    public void execute(SqlStatement object, List<SqlVisitor> object2) {
        this.log.info("Executing with the '" + this.getName() + "' executor");
        object = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)object, this.database);
        this.database.getConnection();
        try {
            object2 = new SqlPlusRunner(this.changeSet, null, this.resourceAccessor);
            ((ExecuteShellCommandChange)object2).addArg("-v");
            ((SqlPlusRunner)object2).executeCommand(this.database);
            this.log.info("Successfully validated 'sqlplus'");
            new SqlPlusRunner(this.changeSet, (Sql[])object, this.resourceAccessor).executeCommand(this.database);
            object = String.format("\nSuccess!  Changeset id:%s, author:%s executed with 'runWith=\"sqlplus\"'.\nLearn more at http://docs.liquibase.com.", this.changeSet.getId(), this.changeSet.getAuthor());
            this.log.info((String)object);
            return;
        }
        catch (Exception exception) {
            object = String.format("\n'sqlplus' failed, please check the spool/log file for the exact Oracle error number and message.\nChangeset id:%s, author:%s not executed.\nLearn more about 'runWith' attributes for changesets at http://docs.liquibase.com.", this.changeSet.getId(), this.changeSet.getAuthor());
            this.log.info((String)object);
            throw new DatabaseException(exception);
        }
    }
}

