/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class CmdInformationMultiple
implements CmdInformation {
    private ArrayList<Long> insertIds;
    private ArrayList<Integer> updateCounts;
    private int insertIdNumber = 0;
    private int expectedSize;
    private int autoIncrement;
    private int moreResults;
    private boolean hasException;

    public CmdInformationMultiple(int expectedSize, int autoIncrement) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayList(expectedSize);
        this.updateCounts = new ArrayList(expectedSize);
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3);
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1);
    }

    @Override
    public void addSuccessStat(int updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber += updateCount;
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator<Integer> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public int[] getRewriteUpdateCounts() {
        int[] ret = new int[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3 : -2);
        return ret;
    }

    @Override
    public int getUpdateCount() {
        if (this.moreResults >= this.updateCounts.size()) {
            return -1;
        }
        return this.updateCounts.get(this.moreResults);
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        for (int updateCount : this.updateCounts) {
            long insertId;
            if (updateCount == -3 || updateCount == -1 || (insertId = idIterator.next().longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        Iterator<Integer> updateIterator = this.updateCounts.iterator();
        for (int element = 0; element <= this.moreResults; ++element) {
            long insertId;
            int updateCount = updateIterator.next();
            if (updateCount == -3 || updateCount == -1 || (insertId = idIterator.next().longValue()) <= 0L || element != this.moreResults) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        if (this.moreResults++ < this.updateCounts.size() - 1) {
            return this.updateCounts.get(this.moreResults) != -1;
        }
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        if (this.updateCounts.size() >= 0) {
            return this.updateCounts.get(this.moreResults) != -1;
        }
        return true;
    }
}

