/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.document.images.AbstractImageProvider;
import fr.opensagres.xdocreport.document.images.IImageInfo;
import fr.opensagres.xdocreport.document.images.SimpleImageInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayImageProvider
extends AbstractImageProvider {
    private byte[] imageByteArray;

    public ByteArrayImageProvider(InputStream imageStream) throws IOException {
        this(imageStream, false);
    }

    public ByteArrayImageProvider(InputStream imageStream, boolean useImageSize) throws IOException {
        this(imageStream != null ? IOUtils.toByteArray((InputStream)imageStream) : null, useImageSize);
    }

    public ByteArrayImageProvider(byte[] imageByteArray) {
        this(imageByteArray, false);
    }

    public ByteArrayImageProvider(byte[] imageByteArray, boolean useImageSize) {
        super(useImageSize);
        this.setImageByteArray(imageByteArray);
    }

    public void setImageStream(InputStream imageStream) throws IOException {
        this.setImageByteArray(IOUtils.toByteArray((InputStream)imageStream));
    }

    public void setImageByteArray(byte[] imageByteArray) {
        this.imageByteArray = imageByteArray;
        super.resetImageInfo();
    }

    public InputStream getImageStream() {
        return new ByteArrayInputStream(this.getImageByteArray());
    }

    public byte[] getImageByteArray() {
        return this.imageByteArray;
    }

    @Override
    public void write(OutputStream output) throws IOException {
        IOUtils.write((byte[])this.imageByteArray, (OutputStream)output);
    }

    @Override
    public ImageFormat getImageFormat() {
        try {
            IImageInfo imageInfo = this.getImageInfo();
            if (imageInfo == null) {
                return null;
            }
            return imageInfo.getMimeType();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected IImageInfo loadImageInfo() throws IOException {
        if (this.imageByteArray == null) {
            return null;
        }
        SimpleImageInfo imageInfo = new SimpleImageInfo();
        imageInfo.setInput(new ByteArrayInputStream(this.imageByteArray));
        if (!imageInfo.check()) {
            throw new IOException("Unable to read image info.");
        }
        return imageInfo;
    }

    @Override
    protected boolean doIsValid() {
        return this.getImageByteArray() != null;
    }
}

