/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.quartz;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.UnableToInterruptJobException;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.util.ReflectionUtils;

public class GrailsJobFactory
extends AdaptableJobFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        String grailsJobName = (String)bundle.getJobDetail().getJobDataMap().get((Object)"org.grails.plugins.quartz.grailsJobName");
        if (grailsJobName != null) {
            return new GrailsJob(this.applicationContext.getBean(grailsJobName));
        }
        return super.createJobInstance(bundle);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PersistJobDataAfterExecution
    @DisallowConcurrentExecution
    public static class StatefulGrailsJob
    extends GrailsJob {
        public StatefulGrailsJob(Object job) {
            super(job);
        }
    }

    public static class GrailsJob
    implements InterruptableJob {
        private Object job;
        private Method executeMethod;
        private Method interruptMethod;
        boolean passExecutionContext;

        public GrailsJob(Object job) {
            this.job = job;
            this.executeMethod = ReflectionUtils.findMethod(job.getClass(), (String)"execute", (Class[])null);
            if (this.executeMethod == null) {
                throw new IllegalArgumentException(MessageFormat.format("{0} should declare #{1}() method", job.getClass().getName(), "execute"));
            }
            switch (this.executeMethod.getParameterTypes().length) {
                case 0: {
                    this.passExecutionContext = false;
                    break;
                }
                case 1: {
                    this.passExecutionContext = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format("{0}#{1}() method should take either no arguments or one argument of type JobExecutionContext", job.getClass().getName(), "execute"));
                }
            }
            this.interruptMethod = ReflectionUtils.findMethod(job.getClass(), (String)"interrupt");
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                if (this.passExecutionContext) {
                    this.executeMethod.invoke(this.job, context);
                } else {
                    this.executeMethod.invoke(this.job, new Object[0]);
                }
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException instanceof JobExecutionException) {
                    throw (JobExecutionException)targetException;
                }
                throw new JobExecutionException(targetException);
            }
            catch (IllegalAccessException iae) {
                JobExecutionException criticalError = new JobExecutionException(MessageFormat.format("Cannot invoke {0}#{1}() method", this.job.getClass().getName(), this.executeMethod.getName()), (Throwable)iae);
                criticalError.setUnscheduleAllTriggers(true);
                throw criticalError;
            }
        }

        public void interrupt() throws UnableToInterruptJobException {
            if (this.interruptMethod != null) {
                try {
                    this.interruptMethod.invoke(this.job, new Object[0]);
                }
                catch (Throwable e) {
                    throw new UnableToInterruptJobException(e);
                }
            } else {
                throw new UnableToInterruptJobException(this.job.getClass().getName() + " doesn't support interruption");
            }
        }

        public Object getJob() {
            return this.job;
        }
    }
}

