/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberPercentageStyle
extends NumberPercentageStyleElement {
    public OdfNumberPercentageStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberPercentageStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.buildFromFormat(format);
    }

    public String getFormat() {
        String result = "";
        for (Node m = this.getFirstChild(); m != null; m = m.getNextSibling()) {
            if (m instanceof NumberNumberElement) {
                result = result + this.getNumberFormat();
                continue;
            }
            if (!(m instanceof NumberTextElement)) continue;
            String textcontent = m.getTextContent();
            if (textcontent == null || textcontent.length() == 0) {
                textcontent = " ";
            }
            result = result + textcontent;
        }
        return result;
    }

    public String getNumberFormat() {
        int i;
        String result = "";
        NumberNumberElement number = OdfElement.findFirstChildNode(NumberNumberElement.class, (Node)((Object)this));
        boolean isGroup = number.getNumberGroupingAttribute();
        int decimalPos = number.getNumberDecimalPlacesAttribute() == null ? 0 : number.getNumberDecimalPlacesAttribute();
        int minInt = number.getNumberMinIntegerDigitsAttribute() == null ? 1 : number.getNumberMinIntegerDigitsAttribute();
        for (i = 0; i < minInt; ++i) {
            result = (i + 1) % 3 == 0 && isGroup ? ",0" + result : "0" + result;
        }
        while (isGroup && result.indexOf(44) == -1) {
            result = (i + 1) % 3 == 0 && isGroup ? ",#" + result : "#" + result;
            ++i;
        }
        result = "#" + result;
        if (decimalPos > 0) {
            result = result + ".";
            for (i = 0; i < decimalPos; ++i) {
                result = result + "0";
            }
        }
        return result;
    }

    public void buildFromFormat(String format) {
        Matcher m;
        Pattern p = Pattern.compile("[#0,.]+");
        if (format != null && !format.equals("") && (m = p.matcher(format)).find()) {
            char ch;
            int pos;
            String preMatch = format.substring(0, m.start());
            String numberSpec = format.substring(m.start(), m.end());
            String postMatch = format.substring(m.end());
            this.emitText(preMatch);
            NumberNumberElement number = new NumberNumberElement((OdfFileDom)((Object)this.getOwnerDocument()));
            int nDigits = 0;
            for (pos = 0; pos < numberSpec.length() && (ch = numberSpec.charAt(pos)) != '.'; ++pos) {
                if (ch == ',') {
                    number.setNumberGroupingAttribute(new Boolean(true));
                    continue;
                }
                if (ch != '0') continue;
                ++nDigits;
            }
            number.setNumberMinIntegerDigitsAttribute(nDigits);
            if (pos < numberSpec.length()) {
                number.setNumberDecimalPlacesAttribute(numberSpec.length() - (pos + 1));
            }
            this.appendChild((Node)((Object)number));
            this.emitText(postMatch);
        }
    }

    private void emitText(String textBuffer) {
        if (!textBuffer.equals("")) {
            NumberTextElement textElement = new NumberTextElement((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    public void setMapPositive(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild((Node)((Object)map));
    }

    public void setMapNegative(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild((Node)((Object)map));
    }
}

