/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.table.tc;

import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.table.tc.AbstractTcProperty;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TextDirection;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class TextDir
extends AbstractTcProperty {
    public static final String CSS_NAME = "transform";
    public static final String FO_NAME = "reference-orientation";
    private static final String DEFAULT_LEFT_TO_RIGHT = "lrTb";

    @Override
    public String getCssName() {
        return CSS_NAME;
    }

    public TextDir() {
        TextDirection textDirection = Context.getWmlObjectFactory().createTextDirection();
        textDirection.setVal(DEFAULT_LEFT_TO_RIGHT);
        this.setObject(textDirection);
    }

    public TextDir(TextDirection textDirection) {
        this.setObject(textDirection);
    }

    public TextDir(CSSValue value) {
        this.debug(CSS_NAME, value);
        TextDirection textDirection = Context.getWmlObjectFactory().createTextDirection();
        if (value.getCssText().toLowerCase().equals("rotate(0deg)")) {
            textDirection.setVal(DEFAULT_LEFT_TO_RIGHT);
        } else if (value.getCssText().toLowerCase().equals("rotate(270deg)")) {
            textDirection.setVal("btLr");
        } else if (value.getCssText().toLowerCase().equals("rotate(90deg)")) {
            textDirection.setVal("tbRl");
        } else {
            log.warn("How to handle transform: " + value.getCssText());
            textDirection.setVal(DEFAULT_LEFT_TO_RIGHT);
        }
        this.setObject(textDirection);
    }

    @Override
    public String getCssProperty() {
        String val = ((TextDirection)this.getObject()).getVal();
        if ("btLr".equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(270deg)");
        }
        if (DEFAULT_LEFT_TO_RIGHT.equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(0deg)");
        }
        if ("lrTbV".equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(0deg)");
        }
        if ("tbLrV".equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(270deg)");
        }
        if ("tbRl".equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(90deg)");
        }
        if ("btLrl".equals(val)) {
            return TextDir.composeCss(CSS_NAME, "rotate(270deg)");
        }
        log.warn("How to handle TextDirection of " + val);
        return "";
    }

    @Override
    public void setXslFO(Element foElement) {
        String val = ((TextDirection)this.getObject()).getVal();
        if ("btLr".equals(val)) {
            foElement.setAttribute(FO_NAME, "90");
        } else if (DEFAULT_LEFT_TO_RIGHT.equals(val)) {
            foElement.setAttribute(FO_NAME, "0");
        } else if ("lrTbV".equals(val)) {
            foElement.setAttribute(FO_NAME, "0");
        } else if ("tbLrV".equals(val)) {
            foElement.setAttribute(FO_NAME, "90");
        } else if ("tbRl".equals(val)) {
            foElement.setAttribute(FO_NAME, "-90");
        } else if ("tbRl".equals(val)) {
            foElement.setAttribute(FO_NAME, "-90");
        } else {
            log.warn("How to handle TextDirection of " + val);
        }
    }

    @Override
    public void set(TcPr tcPr) {
        tcPr.setTextDirection((TextDirection)this.getObject());
    }
}

