/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.catalina.filters.FilterBase;

public class RestCsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private static final Pattern NON_MODIFYING_METHODS_PATTERN = Pattern.compile("GET|HEAD|OPTIONS");
    private Set<String> pathsAcceptingParams = new HashSet<String>();
    private String pathsDelimiter = ",";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_REST_NONCE_HEADER_NAME", "X-CSRF-Token");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            RestCsrfPreventionStrategy strategy;
            MethodType mType = MethodType.MODIFYING_METHOD;
            String method = ((HttpServletRequest)request).getMethod();
            if (method != null && NON_MODIFYING_METHODS_PATTERN.matcher(method).matches()) {
                mType = MethodType.NON_MODIFYING_METHOD;
            }
            switch (mType) {
                case NON_MODIFYING_METHOD: {
                    strategy = new FetchRequest();
                    break;
                }
                default: {
                    strategy = new StateChangingRequest();
                }
            }
            if (!strategy.apply((HttpServletRequest)request, (HttpServletResponse)response)) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void setPathsAcceptingParams(String pathsList) {
        if (pathsList != null) {
            for (String element : pathsList.split(this.pathsDelimiter)) {
                this.pathsAcceptingParams.add(element.trim());
            }
        }
    }

    public Set<String> getPathsAcceptingParams() {
        return this.pathsAcceptingParams;
    }

    private class FetchRequest
    extends RestCsrfPreventionStrategy {
        private FetchRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest request, HttpServletResponse response) {
            if ("Fetch".equalsIgnoreCase(this.extractNonceFromRequestHeader(request, "X-CSRF-Token"))) {
                String nonceFromSessionStr = this.extractNonceFromSession(request.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE");
                if (nonceFromSessionStr == null) {
                    nonceFromSessionStr = RestCsrfPreventionFilter.this.generateNonce(request);
                    this.storeNonceToSession(Objects.requireNonNull(request.getSession(true)), "org.apache.catalina.filters.CSRF_REST_NONCE", nonceFromSessionStr);
                }
                this.storeNonceToResponse(response, "X-CSRF-Token", nonceFromSessionStr);
                if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                    RestCsrfPreventionFilter.this.getLogger().debug(FilterBase.sm.getString("restCsrfPreventionFilter.fetch.debug", request.getMethod(), request.getRequestURI()));
                }
            }
            return true;
        }
    }

    private class StateChangingRequest
    extends RestCsrfPreventionStrategy {
        private StateChangingRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest request, HttpServletResponse response) throws IOException {
            HttpSession session;
            String nonceSession;
            String nonceRequest = this.extractNonceFromRequest(request);
            if (this.isValidStateChangingRequest(nonceRequest, nonceSession = this.extractNonceFromSession(session = request.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE"))) {
                return true;
            }
            this.storeNonceToResponse(response, "X-CSRF-Token", "Required");
            response.sendError(RestCsrfPreventionFilter.this.getDenyStatus(), FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce"));
            if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                RestCsrfPreventionFilter.this.getLogger().debug(FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce.debug", request.getMethod(), request.getRequestURI(), request.getRequestedSessionId() != null, session, nonceRequest != null, nonceSession != null));
            }
            return false;
        }

        private boolean isValidStateChangingRequest(String reqNonce, String sessionNonce) {
            return reqNonce != null && sessionNonce != null && Objects.equals(reqNonce, sessionNonce);
        }

        private String extractNonceFromRequest(HttpServletRequest request) {
            String nonceFromRequest = this.extractNonceFromRequestHeader(request, "X-CSRF-Token");
            if ((nonceFromRequest == null || Objects.equals("", nonceFromRequest)) && !RestCsrfPreventionFilter.this.getPathsAcceptingParams().isEmpty() && RestCsrfPreventionFilter.this.getPathsAcceptingParams().contains(RestCsrfPreventionFilter.this.getRequestedPath(request))) {
                nonceFromRequest = this.extractNonceFromRequestParams(request);
            }
            return nonceFromRequest;
        }

        private String extractNonceFromRequestParams(HttpServletRequest request) {
            String[] params = this.extractNonceFromRequestParams(request, "X-CSRF-Token");
            if (params != null && params.length > 0) {
                String nonce = params[0];
                for (String param : params) {
                    if (Objects.equals(param, nonce)) continue;
                    if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                        RestCsrfPreventionFilter.this.getLogger().debug(FilterBase.sm.getString("restCsrfPreventionFilter.multipleNonce.debug", request.getMethod(), request.getRequestURI()));
                    }
                    return null;
                }
                return nonce;
            }
            return null;
        }
    }

    private static abstract class RestCsrfPreventionStrategy {
        private RestCsrfPreventionStrategy() {
        }

        abstract boolean apply(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

        protected String extractNonceFromRequestHeader(HttpServletRequest request, String key) {
            return request.getHeader(key);
        }

        protected String[] extractNonceFromRequestParams(HttpServletRequest request, String key) {
            return request.getParameterValues(key);
        }

        protected void storeNonceToResponse(HttpServletResponse response, String key, String value) {
            response.setHeader(key, value);
        }

        protected String extractNonceFromSession(HttpSession session, String key) {
            return session == null ? null : (String)session.getAttribute(key);
        }

        protected void storeNonceToSession(HttpSession session, String key, Object value) {
            session.setAttribute(key, value);
        }
    }

    private static enum MethodType {
        NON_MODIFYING_METHOD,
        MODIFYING_METHOD;

    }
}

