/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.properties;

import fr.opensagres.xdocreport.document.textstyling.properties.Color;
import fr.opensagres.xdocreport.document.textstyling.properties.TextAlignment;

public abstract class ContainerProperties {
    private boolean pageBreakBefore;
    private boolean pageBreakAfter;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean strike;
    private boolean subscript;
    private boolean superscript;
    private TextAlignment textAlignment;
    private Color color;
    private String styleName;
    private final ContainerType type;

    public ContainerProperties(ContainerType type) {
        this.type = type;
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isPageBreakBefore() {
        return this.pageBreakBefore;
    }

    public void setPageBreakBefore(boolean pageBreakBefore) {
        this.pageBreakBefore = pageBreakBefore;
    }

    public boolean isPageBreakAfter() {
        return this.pageBreakAfter;
    }

    public void setPageBreakAfter(boolean pageBreakAfter) {
        this.pageBreakAfter = pageBreakAfter;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isStrike() {
        return this.strike;
    }

    public void setStrike(boolean strike) {
        this.strike = strike;
    }

    public boolean isSubscript() {
        return this.subscript;
    }

    public void setSubscript(boolean subscript) {
        this.subscript = subscript;
    }

    public boolean isSuperscript() {
        return this.superscript;
    }

    public void setSuperscript(boolean superscript) {
        this.superscript = superscript;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerProperties that = (ContainerProperties)o;
        if (this.isPageBreakBefore() != that.isPageBreakBefore()) {
            return false;
        }
        if (this.isPageBreakAfter() != that.isPageBreakAfter()) {
            return false;
        }
        if (this.isBold() != that.isBold()) {
            return false;
        }
        if (this.isItalic() != that.isItalic()) {
            return false;
        }
        if (this.isUnderline() != that.isUnderline()) {
            return false;
        }
        if (this.isStrike() != that.isStrike()) {
            return false;
        }
        if (this.isSubscript() != that.isSubscript()) {
            return false;
        }
        if (this.isSuperscript() != that.isSuperscript()) {
            return false;
        }
        if (this.getTextAlignment() != that.getTextAlignment()) {
            return false;
        }
        if (this.getColor() != null ? !this.getColor().equals(that.getColor()) : that.getColor() != null) {
            return false;
        }
        if (this.getStyleName() != null ? !this.getStyleName().equals(that.getStyleName()) : that.getStyleName() != null) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.isPageBreakBefore() ? 1 : 0;
        result = 31 * result + (this.isPageBreakAfter() ? 1 : 0);
        result = 31 * result + (this.isBold() ? 1 : 0);
        result = 31 * result + (this.isItalic() ? 1 : 0);
        result = 31 * result + (this.isUnderline() ? 1 : 0);
        result = 31 * result + (this.isStrike() ? 1 : 0);
        result = 31 * result + (this.isSubscript() ? 1 : 0);
        result = 31 * result + (this.isSuperscript() ? 1 : 0);
        result = 31 * result + (this.getTextAlignment() != null ? this.getTextAlignment().hashCode() : 0);
        result = 31 * result + (this.getColor() != null ? this.getColor().hashCode() : 0);
        result = 31 * result + (this.getStyleName() != null ? this.getStyleName().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    public static enum ContainerType {
        SPAN,
        PARAGRAPH,
        LIST,
        LIST_ITEM,
        HEADER;

    }
}

