/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grails.datastore.gorm.finders.AbstractFinder;
import org.grails.datastore.gorm.finders.DynamicFinder;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionCallback;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.reflect.NameUtils;

public class ListOrderByFinder
extends AbstractFinder {
    private static final Pattern METHOD_PATTERN = Pattern.compile("(listOrderBy)(\\w+)");
    private Pattern pattern = METHOD_PATTERN;

    public ListOrderByFinder(Datastore datastore) {
        super(datastore);
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public Object invoke(Class clazz, String methodName, Object[] arguments) {
        return this.invoke(clazz, methodName, null, arguments);
    }

    @Override
    public Object invoke(final Class clazz, String methodName, final Closure additionalCriteria, final Object[] arguments) {
        Matcher match = this.pattern.matcher(methodName);
        match.find();
        String nameInSignature = match.group(2);
        final String propertyName = NameUtils.decapitalizeFirstChar((String)nameInSignature);
        return this.execute(new SessionCallback<Object>(){

            public Object doInSession(Session session) {
                Query q = session.createQuery(clazz);
                ListOrderByFinder.this.applyAdditionalCriteria(q, additionalCriteria);
                boolean ascending = true;
                if (arguments.length > 0 && arguments[0] instanceof Map) {
                    LinkedHashMap args = new LinkedHashMap((Map)arguments[0]);
                    Object order = args.remove("order");
                    if (order != null && "desc".equalsIgnoreCase(order.toString())) {
                        ascending = false;
                    }
                    DynamicFinder.populateArgumentsForCriteria(clazz, q, args);
                }
                q.order(ascending ? Query.Order.asc((String)propertyName) : Query.Order.desc((String)propertyName));
                q.projections().distinct();
                return ListOrderByFinder.this.invokeQuery(q);
            }
        });
    }

    protected Object invokeQuery(Query q) {
        return q.list();
    }

    @Override
    public boolean isMethodMatch(String methodName) {
        return this.pattern.matcher(methodName.subSequence(0, methodName.length())).find();
    }
}

