/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.quartz;

import grails.plugins.quartz.GrailsJobClass;
import grails.plugins.quartz.GrailsJobFactory;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class JobDetailFactoryBean
implements FactoryBean<JobDetail>,
InitializingBean {
    public static final transient String JOB_NAME_PARAMETER = "org.grails.plugins.quartz.grailsJobName";
    private GrailsJobClass jobClass;
    private JobDetail jobDetail;

    @Required
    public void setJobClass(GrailsJobClass jobClass) {
        this.jobClass = jobClass;
    }

    public void afterPropertiesSet() {
        String name = this.jobClass.getFullName();
        if (name == null) {
            throw new IllegalStateException("name is required");
        }
        String group = this.jobClass.getGroup();
        if (group == null) {
            throw new IllegalStateException("group is required");
        }
        Class clazz = this.jobClass.isConcurrent() ? GrailsJobFactory.GrailsJob.class : GrailsJobFactory.StatefulGrailsJob.class;
        this.jobDetail = JobBuilder.newJob(clazz).withIdentity(name, group).storeDurably(this.jobClass.isDurability()).requestRecovery(this.jobClass.isRequestsRecovery()).usingJobData(JOB_NAME_PARAMETER, name).withDescription(this.jobClass.getDescription()).build();
    }

    public JobDetail getObject() {
        return this.jobDetail;
    }

    public Class<JobDetail> getObjectType() {
        return JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

