/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.validation;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import java.util.ArrayList;
import java.util.List;
import org.grails.datastore.gorm.GormValidateable;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.grails.datastore.gorm.validation.CascadingValidator;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.orm.hibernate.cfg.PropertyConfig;
import org.grails.orm.hibernate.proxy.SimpleHibernateProxyHandler;
import org.grails.validation.GrailsDomainClassValidator;
import org.hibernate.Hibernate;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceAware;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

public class HibernateDomainClassValidator
extends GrailsDomainClassValidator
implements MessageSourceAware,
CascadingValidator,
InitializingBean {
    private BeforeValidateHelper beforeValidateHelper = new BeforeValidateHelper();
    private ProxyHandler proxyHandler = new SimpleHibernateProxyHandler();
    private MappingContext mappingContext;

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = Hibernate.getClass((Object)associatedObject).getName();
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    @Autowired(required=false)
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        Object collection = bean.getPropertyValue(propertyName);
        if (collection == null) {
            return;
        }
        if (this.proxyHandler.isProxy(collection)) {
            if (this.proxyHandler.isInitialized(collection)) {
                super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
            }
        } else {
            super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName, Object indexOrKey) {
        if (this.proxyHandler.isInitialized(associatedObject)) {
            Object object = associatedObject = this.proxyHandler.isProxy(associatedObject) ? this.proxyHandler.unwrap(associatedObject) : associatedObject;
            if (associatedObject != null) {
                this.cascadeBeforeValidate(associatedObject);
                GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClass(associatedObject, persistentProperty);
                if (associatedDomainClass == null || !this.isOwningInstance(bean, associatedDomainClass) && !persistentProperty.isExplicitSaveUpdateCascade()) {
                    GormValidateable validateable;
                    Errors existingErrors;
                    if (associatedObject instanceof GormValidateable && (persistentProperty.isOneToOne() || persistentProperty.isManyToOne()) && (existingErrors = (validateable = (GormValidateable)associatedObject).getErrors()) != null && existingErrors.hasErrors()) {
                        for (FieldError error : existingErrors.getFieldErrors()) {
                            String path = propertyName + '.' + error.getField();
                            errors.rejectValue(path, error.getCode(), error.getArguments(), error.getDefaultMessage());
                        }
                    }
                } else {
                    super.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, indexOrKey);
                }
            }
        }
    }

    protected void cascadeBeforeValidate(Object associatedObject) {
        GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClassFromApplication(associatedObject);
        if (associatedDomainClass != null) {
            this.beforeValidateHelper.invokeBeforeValidate(associatedObject, new ArrayList(associatedDomainClass.getConstrainedProperties().keySet()));
        }
    }

    public void setMappingContext(MappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    private GrailsDomainClass getAssociatedDomainClass(Object associatedObject, GrailsDomainClassProperty persistentProperty) {
        if (persistentProperty.isEmbedded()) {
            return persistentProperty.getComponent();
        }
        if (this.grailsApplication != null) {
            return this.getAssociatedDomainClassFromApplication(associatedObject);
        }
        return persistentProperty.getReferencedDomainClass();
    }

    private boolean isOwningInstance(BeanWrapper bean, GrailsDomainClass associatedDomainClass) {
        for (Class currentClass = bean.getWrappedClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!associatedDomainClass.isOwningClass(currentClass)) continue;
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        PersistentEntity mappedEntity;
        if (this.mappingContext != null && (mappedEntity = this.mappingContext.getPersistentEntity(this.getDomainClass().getFullName())) != null) {
            List persistentProperties = mappedEntity.getPersistentProperties();
            for (PersistentProperty property : persistentProperties) {
                boolean derived;
                if (!(property instanceof Simple)) continue;
                PropertyConfig config = (PropertyConfig)property.getMapping().getMappedForm();
                boolean bl = derived = config.isDerived() || config.getFormula() != null;
                GrailsDomainClassProperty grailsProperty = this.domainClass.getPersistentProperty(property.getName());
                if (grailsProperty == null) continue;
                grailsProperty.setDerived(derived);
            }
            this.mappingContext.addEntityValidator(mappedEntity, (Validator)this);
        }
    }
}

