/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext;

import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

public class SqlPlusRunner
extends ExecuteShellCommandChange {
    private Logger log = LogService.getLog(this.getClass());
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private String spoolFilePath = null;
    private Boolean keepTempFile;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private String errorLoggingIdentifier;

    public SqlPlusRunner() {
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlArray, ResourceAccessor resourceAccessor) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setResourceAccessor(resourceAccessor);
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlplusProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings((Database)object);
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = Boolean.FALSE;
        }
        if (!this.keepTempFile.booleanValue() && this.outFile != null) {
            this.outFile.deleteOnExit();
        }
        if (!list.contains("-L")) {
            list.add("-L");
        }
        list.add(this.buildConnectionString((Database)object));
        if (this.outFile != null) {
            list.add("@" + this.outFile.getAbsolutePath());
        }
        object = StringUtils.join(list, " ").replaceAll("(.*) (.*)/\"(.*)\"@(.)", "$1 $2/******@$4");
        this.log.info("SQLPLUS command:\n".concat(String.valueOf(object)));
        return list;
    }

    @Override
    protected void processResult(int n2, String string3, String string2, Database database) {
        try {
            List<?> list = this.processResultFromDaticalSpErrorLog(n2, database);
            StringBuilder stringBuilder = new StringBuilder();
            if (list == null || list.isEmpty()) {
                super.processResult(n2, string3, string2, database);
                return;
            }
            stringBuilder.append("Error executing change set '");
            stringBuilder.append(this.changeSet.toString());
            stringBuilder.append("'\n");
            for (String string3 : list) {
                stringBuilder.append(string3.toString().concat("\n"));
            }
            throw new DaticalSpErrorLogException(stringBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    @Override
    public void executeCommand(Database database) {
        this.createDaticalSpErrorLogIfNeeded(database);
        this.finalCommandArray = this.createFinalCommandArray(database);
        try {
            super.executeCommand(database);
            if (this.spoolFilePath != null) {
                this.captureSpoolOutputInLog();
            }
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                this.log.info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                return;
            }
        }
        catch (Exception exception) {
            try {
                Exception exception2 = exception;
                if (exception instanceof TimeoutException) {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                    this.processResult(0, null, null, database);
                }
                throw new Exception(exception2);
            }
            catch (Throwable throwable) {
                if (this.spoolFilePath != null) {
                    this.captureSpoolOutputInLog();
                }
                if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                    this.log.info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                }
                throw throwable;
            }
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        String string = database.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        try {
            jdbcExecutor.execute(new RawSqlStatement(String.format("DROP TABLE %s.%s", string, DATICAL_SPERRORLOG)));
            return;
        }
        catch (DatabaseException databaseException) {
            throw new DaticalSpErrorLogException(String.format("Unable to drop table: %s.%s due to an error. Table is locked or it was accidentally dropped", string, DATICAL_SPERRORLOG), databaseException);
        }
    }

    private List<?> processResultFromDaticalSpErrorLog(int n2, Database object) {
        block2: {
            String string = object.getLiquibaseCatalogName();
            JdbcExecutor jdbcExecutor = new JdbcExecutor();
            jdbcExecutor.setDatabase((Database)object);
            object = null;
            try {
                string = String.format("select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='" + this.errorLoggingIdentifier + "'", string, DATICAL_SPERRORLOG);
                object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement(string), String.class);
            }
            catch (DatabaseException databaseException) {
                if (n2 != 0) break block2;
                throw new DaticalSpErrorLogException(String.format("Table: %s unacceptable due to an error. ", DATICAL_SPERRORLOG), databaseException);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSqlplusProperties() {
        if (StringUtils.trimToEmpty(System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows")) {
            this.setExecutable("sqlplus.exe");
        } else {
            this.setExecutable("sqlplus");
        }
        File file = null;
        String string = null;
        Object object = new Properties();
        Set<InputStream> set = this.getLiquibaseProperty("liquibase.sqlplus.path");
        if (set != null && (set = ((ConfigurationProperty)((Object)set)).getValue(String.class)) != null && !((String)((Object)set)).isEmpty()) {
            file = new File((String)((Object)set));
        }
        if ((set = this.getLiquibaseProperty("liquibase.sqlplus.timeout")) != null) {
            string = ((ConfigurationProperty)((Object)set)).getValue(String.class);
        }
        if ((set = this.getLiquibaseProperty("liquibase.sqlplus.temp.keep")) != null) {
            this.keepTempFile = ((ConfigurationProperty)((Object)set)).getValue(Boolean.class);
        }
        set = this.getResourceAccessor();
        InputStream inputStream = null;
        try {
            set = set.getResourcesAsStream("liquibase.sqlplus.conf");
            if (set == null || set.size() == 0) {
                this.log.warning("No configuration file named 'liquibase.sqlplus.conf' found.  Using default values.  Learn more at http://docs.liquibase.com.");
                return;
            }
            inputStream = set.iterator().next();
            ((Properties)object).load(inputStream);
            if (file == null && ((Properties)object).containsKey("liquibase.sqlplus.path")) {
                file = new File(((Properties)object).getProperty("liquibase.sqlplus.path"));
            }
            if (string == null && ((Properties)object).containsKey("liquibase.sqlplus.timeout")) {
                string = ((Properties)object).getProperty("liquibase.sqlplus.timeout");
                try {
                    Integer.parseInt(string);
                }
                catch (Exception exception) {
                    throw new UnexpectedLiquibaseException("Invalid value '" + string + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
                }
            }
            if (this.keepTempFile == null && ((Properties)object).containsKey("liquibase.sqlplus.keep.temp")) {
                if (!((object = ((Properties)object).getProperty("liquibase.sqlplus.keep.temp")) == null || ((String)object).isEmpty() || ((String)(object = ((String)object).toLowerCase())).equals("true") || ((String)object).equals("false"))) {
                    throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.sqlplus.keep.temp'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
                }
                this.keepTempFile = Boolean.valueOf((String)object);
            }
        }
        catch (IOException iOException) {
            try {
                throw new UnexpectedLiquibaseException(iOException);
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        if (file != null) {
            if (!file.exists()) {
                throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
            }
            if (!file.canExecute()) {
                throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + file.getAbsolutePath() + " cannot be executed");
            }
            try {
                this.setExecutable(file.getCanonicalPath());
                this.log.info("Using the 'sqlplus' executable located at:  '" + file.getCanonicalPath() + "'");
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
        }
        if (string == null) return;
        this.validateTimeout(string);
        this.setTimeout(string);
    }

    private ConfigurationProperty getLiquibaseProperty(String string) {
        LiquibaseProConfiguration liquibaseProConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class);
        ConfigurationProperty configurationProperty = null;
        try {
            configurationProperty = liquibaseProConfiguration.getProperty(string);
        }
        catch (Exception exception) {}
        return configurationProperty;
    }

    private void validateTimeout(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if ((string = string.trim()).equals("-1")) {
            return;
        }
        if (string.equals("0")) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        try {
            if (Integer.parseInt(string) <= 0) {
                throw new UnexpectedLiquibaseException("Invalid timeout value of '" + string + "'");
            }
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + string + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSqlStrings(Database object) {
        String string;
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        this.log.info("Creating the SQL run script");
        try {
            string = ("liquibase-spool-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-").replaceAll(" ", "_").replaceAll(":", "_");
            this.log.info("Creating temporary spool file for '" + string + "'");
            File file = File.createTempFile(string, ".spool");
            file.deleteOnExit();
            this.spoolFilePath = file.getAbsolutePath();
            this.spoolFilePath = this.spoolFilePath.replaceAll("\\s", "");
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        try {
            string = ("liquibase-sqlplus-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-").replaceAll(" ", "_").replaceAll(":", "_");
            this.log.info("Creating temporary file for '" + string + "'");
            this.outFile = File.createTempFile(string, ".sql");
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        boolean bl2 = true;
        Sql[] sqlArray = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!sqlArray[i2].toSql().toLowerCase().startsWith("whenever")) continue;
            bl2 = false;
            break;
        }
        String string2 = object.getLiquibaseCatalogName();
        BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
        Throwable throwable = null;
        try {
            bufferedWriter.write("SET ECHO ON\n");
            bufferedWriter.write("SET DEFINE OFF\n");
            bufferedWriter.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' \n", string2, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
            if (bl2) {
                bufferedWriter.write("WHENEVER SQLERROR EXIT FAILURE;\n");
            }
            bufferedWriter.write("SPOOL " + this.spoolFilePath + "\n");
            bufferedWriter.write("SET SQLBLANKLINES ON\n\n");
            boolean bl3 = false;
            Sql[] sqlArray2 = this.sqlStrings;
            int n3 = this.sqlStrings.length;
            for (n2 = 0; n2 < n3; ++n2) {
                for (String string3 : sqlArray2[n2].toSql().split("\n")) {
                    if (bl3 || !string3.toLowerCase().contains("spool ")) continue;
                    this.log.warning("SPOOL statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
                    bl3 = true;
                }
            }
            sqlArray2 = this.sqlStrings;
            int n4 = this.sqlStrings.length;
            for (n2 = 0; n2 < n4; ++n2) {
                String string4 = sqlArray2[n2].toSql().replace("\r", "");
                bufferedWriter.write(string4 + "\n");
            }
            bufferedWriter.write("EXIT;\n");
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (bufferedWriter == null) throw throwable3;
                if (throwable != null) {
                    try {
                        bufferedWriter.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    bufferedWriter.close();
                }
                throw throwable3;
            }
        }
        bufferedWriter.close();
        return;
    }

    private void createDaticalSpErrorLogIfNeeded(Database object) {
        String string = object.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        try {
            object = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement((String)object), String.class);
        }
        catch (DatabaseException databaseException) {
            throw new DaticalSpErrorLogException(String.format("Can't check if  table: %s exist due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (object != null && !object.isEmpty()) {
            return;
        }
        try {
            object = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", string, DATICAL_SPERRORLOG);
            jdbcExecutor.execute(new RawSqlStatement((String)object));
            return;
        }
        catch (DatabaseException databaseException) {
            throw new DaticalSpErrorLogException(String.format("Can't create table: %s.%s exist due to an error", string, DATICAL_SPERRORLOG), databaseException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureSpoolOutputInLog() {
        block9: {
            if (!new File(this.spoolFilePath).exists()) {
                this.log.warning("Unable to locate spool output file " + this.spoolFilePath);
                return;
            }
            this.log.info("Writing spool output to log");
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(this.spoolFilePath, new String[0]));
            Throwable throwable = null;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.log.info(string);
                }
                if (bufferedReader == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (bufferedReader == null) throw throwable4;
                    if (throwable == null) {
                        bufferedReader.close();
                        throw throwable4;
                    }
                    try {
                        bufferedReader.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            bufferedReader.close();
        }
        this.log.info("\n");
        this.log.info("Spool output written to log");
    }

    private String buildConnectionString(Database object) {
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = object.getConnectionUserName();
        String string2 = ((ProJdbcConnection)object).getPassword();
        if (string2 == null) {
            throw new UnexpectedLiquibaseException("Password for sqlplus was not set by the calling program, or could not determine password from connection.");
        }
        object = object.getURL().split("jdbc:oracle:(.*):@")[1];
        return string + "/\"" + string2 + "\"@" + (String)object;
    }
}

