/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.management.impl;

import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.management.impl.EhcacheHibernate;
import org.hibernate.cache.ehcache.management.impl.EhcacheHibernateMBeanRegistration;
import org.hibernate.cache.ehcache.management.impl.EhcacheHibernateMbeanNames;
import org.jboss.logging.Logger;

public class EhcacheHibernateMBeanRegistrationImpl
implements EhcacheHibernateMBeanRegistration,
CacheManagerEventListener {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)EhcacheHibernateMBeanRegistrationImpl.class.getName());
    private static final int MAX_MBEAN_REGISTRATION_RETRIES = 50;
    private Status status = Status.STATUS_UNINITIALISED;
    private volatile EhcacheHibernate ehcacheHibernate;
    private volatile ObjectName cacheManagerObjectName;

    @Override
    public synchronized void registerMBeanForCacheManager(CacheManager manager, Properties properties) throws Exception {
        String sessionFactoryName = properties.getProperty("hibernate.session_factory_name");
        String name = sessionFactoryName == null ? manager.getName() : ("".equals(sessionFactoryName.trim()) ? manager.getName() : sessionFactoryName);
        this.registerBean(name, manager);
    }

    private void registerBean(String name, CacheManager manager) throws Exception {
        boolean success;
        String registeredCacheManagerName;
        this.ehcacheHibernate = new EhcacheHibernate(manager);
        int tries = 0;
        InstanceAlreadyExistsException exception = null;
        String cacheManagerClusterUUID = manager.getClusterUUID();
        while (true) {
            registeredCacheManagerName = name;
            if (tries != 0) {
                registeredCacheManagerName = registeredCacheManagerName + "_" + tries;
            }
            try {
                MBeanServer mBeanServer = this.getMBeanServer();
                this.cacheManagerObjectName = EhcacheHibernateMbeanNames.getCacheManagerObjectName(cacheManagerClusterUUID, registeredCacheManagerName);
                mBeanServer.registerMBean(this.ehcacheHibernate, this.cacheManagerObjectName);
                success = true;
            }
            catch (InstanceAlreadyExistsException e) {
                success = false;
                exception = e;
                if (++tries < 50) continue;
            }
            break;
        }
        if (!success) {
            throw new Exception("Cannot register mbean for CacheManager with name" + manager.getName() + " after " + 50 + " retries. Last tried name=" + registeredCacheManagerName, exception);
        }
        this.status = Status.STATUS_ALIVE;
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void enableHibernateStatisticsSupport(SessionFactory sessionFactory) {
        this.ehcacheHibernate.enableHibernateStatistics(sessionFactory);
    }

    public synchronized void dispose() throws CacheException {
        if (this.status == Status.STATUS_SHUTDOWN) {
            return;
        }
        try {
            this.getMBeanServer().unregisterMBean(this.cacheManagerObjectName);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering object instance " + this.cacheManagerObjectName + " . Error was " + e.getMessage(), e);
        }
        this.ehcacheHibernate = null;
        this.cacheManagerObjectName = null;
        this.status = Status.STATUS_SHUTDOWN;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public void init() throws CacheException {
    }

    public void notifyCacheAdded(String cacheName) {
    }

    public void notifyCacheRemoved(String cacheName) {
    }
}

