/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.repository.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.repository.redis.RedisUtils;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;

public class RedisMultiMetricRepository
implements MultiMetricRepository {
    private static final String DEFAULT_METRICS_PREFIX = "spring.groups.";
    private final String prefix;
    private final String keys;
    private final BoundZSetOperations<String, String> zSetOperations;
    private final RedisOperations<String, String> redisOperations;

    public RedisMultiMetricRepository(RedisConnectionFactory redisConnectionFactory) {
        this(redisConnectionFactory, DEFAULT_METRICS_PREFIX);
    }

    public RedisMultiMetricRepository(RedisConnectionFactory redisConnectionFactory, String prefix) {
        Assert.notNull((Object)redisConnectionFactory, (String)"RedisConnectionFactory must not be null");
        this.redisOperations = RedisUtils.stringTemplate(redisConnectionFactory);
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
        this.keys = "keys." + this.prefix.substring(0, prefix.length() - 1);
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.keys);
    }

    @Override
    public Iterable<Metric<?>> findAll(String group) {
        BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)this.keyFor(group));
        Set keys = zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList result = new ArrayList(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            String key = (String)keysIt.next();
            result.add(this.deserialize(key, v, zSetOperations.score((Object)key)));
        }
        return result;
    }

    @Override
    public void set(String group, Collection<Metric<?>> values) {
        String groupKey = this.keyFor(group);
        this.trackMembership(groupKey);
        BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)groupKey);
        for (Metric<?> metric : values) {
            String raw = this.serialize(metric);
            String key = this.keyFor(metric.getName());
            zSetOperations.add((Object)key, ((Number)metric.getValue()).doubleValue());
            this.redisOperations.opsForValue().set((Object)key, (Object)raw);
        }
    }

    @Override
    public void increment(String group, Delta<?> delta) {
        String groupKey = this.keyFor(group);
        this.trackMembership(groupKey);
        BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)groupKey);
        String key = this.keyFor(delta.getName());
        double value = zSetOperations.incrementScore((Object)key, ((Number)delta.getValue()).doubleValue());
        String raw = this.serialize(new Metric<Double>(delta.getName(), value, delta.getTimestamp()));
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    @Override
    public Iterable<String> groups() {
        Set range = this.zSetOperations.range(0L, -1L);
        ArrayList<String> result = new ArrayList<String>();
        for (String key : range) {
            result.add(key.substring(this.prefix.length()));
        }
        return result;
    }

    @Override
    public long countGroups() {
        return this.zSetOperations.size();
    }

    @Override
    public void reset(String group) {
        String groupKey = this.keyFor(group);
        if (this.redisOperations.hasKey((Object)groupKey).booleanValue()) {
            BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)groupKey);
            Set keys = zSetOperations.range(0L, -1L);
            for (String key : keys) {
                this.redisOperations.delete((Object)key);
            }
            this.redisOperations.delete((Object)groupKey);
        }
        this.zSetOperations.remove(new Object[]{groupKey});
    }

    private Metric<?> deserialize(String redisKey, String v, Double value) {
        Date timestamp = new Date(Long.valueOf(v));
        return new Metric<Double>(this.nameFor(redisKey), value, timestamp);
    }

    private String serialize(Metric<?> entity) {
        return String.valueOf(entity.getTimestamp().getTime());
    }

    private String keyFor(String name) {
        return this.prefix + name;
    }

    private String nameFor(String redisKey) {
        Assert.state((redisKey != null && redisKey.startsWith(this.prefix) ? 1 : 0) != 0, (String)("Invalid key does not start with prefix: " + redisKey));
        return redisKey.substring(this.prefix.length());
    }

    private void trackMembership(String redisKey) {
        this.zSetOperations.incrementScore((Object)redisKey, 0.0);
    }
}

