/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.ExtendedInboundHeaders;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.InboundHeaders;
import java.net.URI;

public class HttpParameters
implements ExternalParameters {
    private final String library;
    private final URI uri;
    private final String procedure;
    private final Integer statusCode;
    private final String statusText;
    private final InboundHeaders inboundResponseHeaders;
    private final ExtendedInboundHeaders extendedInboundResponseHeaders;

    protected HttpParameters(String library, URI uri, String procedure, InboundHeaders inboundHeaders) {
        this(library, uri, procedure, inboundHeaders, null);
    }

    protected HttpParameters(String library, URI uri, String procedure, InboundHeaders inboundHeaders, ExtendedInboundHeaders extendedInboundHeaders) {
        this.library = library;
        this.uri = uri;
        this.procedure = procedure;
        this.statusCode = null;
        this.statusText = null;
        this.inboundResponseHeaders = inboundHeaders;
        this.extendedInboundResponseHeaders = extendedInboundHeaders;
    }

    protected HttpParameters(HttpParameters httpParameters) {
        this.library = httpParameters.library;
        this.uri = httpParameters.uri;
        this.procedure = httpParameters.procedure;
        this.statusCode = httpParameters.statusCode;
        this.statusText = httpParameters.statusText;
        this.inboundResponseHeaders = httpParameters.inboundResponseHeaders;
        this.extendedInboundResponseHeaders = null;
    }

    protected HttpParameters(Builder builder) {
        this.library = builder.library;
        this.uri = builder.uri;
        this.procedure = builder.procedure;
        this.statusCode = builder.statusCode;
        this.statusText = builder.statusText;
        this.inboundResponseHeaders = builder.inboundHeaders;
        this.extendedInboundResponseHeaders = builder.extendedInboundHeaders;
    }

    public String getLibrary() {
        return this.library;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public InboundHeaders getInboundResponseHeaders() {
        return this.inboundResponseHeaders;
    }

    public InboundHeaders getExtendedInboundResponseHeaders() {
        return this.extendedInboundResponseHeaders;
    }

    public static UriParameter library(String library) {
        return new Builder(library);
    }

    public static interface Build {
        public Build status(Integer var1, String var2);

        public HttpParameters build();
    }

    public static interface InboundHeadersParameter {
        public Build inboundHeaders(InboundHeaders var1);

        public Build extendedInboundHeaders(ExtendedInboundHeaders var1);

        public Build noInboundHeaders();
    }

    public static interface ProcedureParameter {
        public InboundHeadersParameter procedure(String var1);
    }

    public static interface UriParameter {
        public ProcedureParameter uri(URI var1);
    }

    protected static class Builder
    implements UriParameter,
    ProcedureParameter,
    InboundHeadersParameter,
    Build {
        private String library;
        private URI uri;
        private String procedure;
        private Integer statusCode;
        private String statusText;
        private InboundHeaders inboundHeaders;
        private ExtendedInboundHeaders extendedInboundHeaders;

        public Builder(String library) {
            this.library = library;
        }

        @Override
        public ProcedureParameter uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public InboundHeadersParameter procedure(String procedure) {
            this.procedure = procedure;
            return this;
        }

        @Override
        public Build inboundHeaders(InboundHeaders inboundHeaders) {
            this.inboundHeaders = inboundHeaders;
            return this;
        }

        @Override
        public Build extendedInboundHeaders(ExtendedInboundHeaders extendedInboundHeaders) {
            this.extendedInboundHeaders = extendedInboundHeaders;
            return this;
        }

        @Override
        public Build noInboundHeaders() {
            return this;
        }

        @Override
        public Build status(Integer statusCode, String statusText) {
            this.statusCode = statusCode;
            if (statusText != null && !statusText.isEmpty()) {
                this.statusText = statusText;
            }
            return this;
        }

        @Override
        public HttpParameters build() {
            return new HttpParameters(this);
        }
    }
}

