/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyFactory;
import org.apache.poi.poifs.property.PropertyTableBase;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class NPropertyTable
extends PropertyTableBase {
    private static final POILogger _logger = POILogFactory.getLogger(NPropertyTable.class);
    private POIFSBigBlockSize _bigBigBlockSize;

    public NPropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    public NPropertyTable(HeaderBlock headerBlock, NPOIFSFileSystem filesystem) throws IOException {
        super(headerBlock, NPropertyTable.buildProperties(new NPOIFSStream(filesystem, headerBlock.getPropertyStart()).iterator(), headerBlock.getBigBlockSize()));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    private static List<Property> buildProperties(Iterator<ByteBuffer> dataSource, POIFSBigBlockSize bigBlockSize) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (dataSource.hasNext()) {
            byte[] data;
            ByteBuffer bb = dataSource.next();
            if (bb.hasArray() && bb.arrayOffset() == 0 && bb.array().length == bigBlockSize.getBigBlockSize()) {
                data = bb.array();
            } else {
                data = new byte[bigBlockSize.getBigBlockSize()];
                int toRead = data.length;
                if (bb.remaining() < bigBlockSize.getBigBlockSize()) {
                    _logger.log(5, "Short Property Block, ", bb.remaining(), " bytes instead of the expected " + bigBlockSize.getBigBlockSize());
                    toRead = bb.remaining();
                }
                bb.get(data, 0, toRead);
            }
            PropertyFactory.convertToProperties(data, properties);
        }
        return properties;
    }

    @Override
    public int countBlocks() {
        long rawSize = (long)this._properties.size() * 128L;
        int blkSize = this._bigBigBlockSize.getBigBlockSize();
        int numBlocks = (int)(rawSize / (long)blkSize);
        if (rawSize % (long)blkSize != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    public void preWrite() {
        ArrayList<Property> pList = new ArrayList<Property>();
        int i = 0;
        for (Property p : this._properties) {
            if (p == null) continue;
            p.setIndex(i++);
            pList.add(p);
        }
        for (Property p : pList) {
            p.preWrite();
        }
    }

    public void write(NPOIFSStream stream) throws IOException {
        OutputStream os = stream.getOutputStream();
        for (Property property : this._properties) {
            if (property == null) continue;
            property.writeData(os);
        }
        os.close();
        if (this.getStartBlock() != stream.getStartBlock()) {
            this.setStartBlock(stream.getStartBlock());
        }
    }
}

