/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.lang.reflect.Constructor;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtectionSettings {
    protected static Logger log = LoggerFactory.getLogger(ProtectionSettings.class);
    protected OpcPackage pkg;

    public ProtectionSettings(OpcPackage pkg) {
        this.pkg = pkg;
    }

    public boolean getMarkAsFinal() {
        if (this.pkg.getDocPropsCustomPart() == null) {
            return false;
        }
        return this.pkg.getDocPropsCustomPart().getMarkAsFinal();
    }

    public void setMarkAsFinal(boolean val) {
        if (this.pkg.getDocPropsCustomPart() == null && val) {
            this.pkg.addDocPropsCustomPart();
        }
        if (this.pkg.getDocPropsCustomPart() == null) {
            return;
        }
        this.pkg.getDocPropsCustomPart().setMarkAsFinal(val);
        if (this.pkg.getDocPropsExtendedPart() == null && val) {
            this.pkg.addDocPropsExtendedPart();
        }
        this.setDocSecurity(0);
        if (this.pkg.getDocPropsCorePart() == null && val) {
            this.pkg.addDocPropsCorePart();
        }
        if (this.pkg.getDocPropsCorePart() != null) {
            ((CoreProperties)this.pkg.getDocPropsCorePart().getJaxbElement()).setContentStatus("Final");
        }
    }

    protected void setDocSecurity(int val) {
        if (this.pkg.getDocPropsExtendedPart() != null) {
            this.pkg.getDocPropsExtendedPart().setDocSecurity(val);
        }
    }

    public Object getSignatureHelper() throws Docx4JException {
        try {
            Class<?> signingClass = Class.forName("com.plutext.dsig.SignatureHelper");
            Constructor<?> ctor = signingClass.getConstructor(OpcPackage.class);
            return ctor.newInstance(this.pkg);
        }
        catch (Exception e) {
            log.warn("Docx4j Enterprise jar v3.3 or greater not found. Required for Digital Signatures.");
            throw new Docx4JException("missing Enterprise version required for Digital Signature functionality");
        }
    }
}

