/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.apache.commons.validator.routines.EmailValidator;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;

public class EmailConstraint
extends AbstractConstraint {
    private final boolean email;

    public EmailConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.email = (Boolean)this.constraintParameter;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [email] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "email";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (!this.email) {
            return;
        }
        EmailValidator emailValidator = EmailValidator.getInstance();
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
        String value = propertyValue.toString();
        if (StringUtils.isEmpty((Object)value)) {
            return;
        }
        if (!emailValidator.isValid(value)) {
            this.rejectValue(target, errors, "default.invalid.email.message", "email.invalid", args);
        }
    }
}

