/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.Date;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;

public abstract class AbstractChangeLogHistoryService
implements ChangeLogHistoryService {
    private Database database;
    private String deploymentId;

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public void reset() {
    }

    @Override
    public ChangeSet.RunStatus getRunStatus(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        RanChangeSet foundRan = this.getRanChangeSet(changeSet);
        if (foundRan == null) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        if (foundRan.getLastCheckSum() == null) {
            try {
                LogService.getLog(this.getClass()).info(LogType.LOG, "Updating NULL md5sum for " + changeSet.toString());
                this.replaceChecksum(changeSet);
            }
            catch (DatabaseException e2) {
                throw new DatabaseException(e2);
            }
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (foundRan.getLastCheckSum().equals(changeSet.generateCheckSum())) {
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (changeSet.shouldRunOnChange()) {
            return ChangeSet.RunStatus.RUN_AGAIN;
        }
        return ChangeSet.RunStatus.INVALID_MD5SUM;
    }

    @Override
    public void upgradeChecksums(DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labels) throws DatabaseException {
        for (RanChangeSet ranChangeSet : this.getRanChangeSets()) {
            ChangeSet changeSet;
            if (ranChangeSet.getLastCheckSum() != null || (changeSet = databaseChangeLog.getChangeSet(ranChangeSet)) == null || !new ContextChangeSetFilter(contexts).accepts(changeSet).isAccepted() || !new DbmsChangeSetFilter(this.getDatabase()).accepts(changeSet).isAccepted()) continue;
            LogService.getLog(this.getClass()).debug(LogType.LOG, "Updating null or out of date checksum on changeSet " + changeSet + " to correct value");
            this.replaceChecksum(changeSet);
        }
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        for (RanChangeSet ranChange : this.getRanChangeSets()) {
            if (!ranChange.isSameAs(changeSet)) continue;
            return ranChange;
        }
        return null;
    }

    @Override
    public Date getRanDate(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        RanChangeSet ranChange = this.getRanChangeSet(changeSet);
        if (ranChange == null) {
            return null;
        }
        return ranChange.getDateExecuted();
    }

    protected abstract void replaceChecksum(ChangeSet var1) throws DatabaseException;

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void resetDeploymentId() {
        this.deploymentId = null;
    }

    @Override
    public void generateDeploymentId() {
        if (this.deploymentId == null) {
            String dateString = String.valueOf(new Date().getTime());
            this.deploymentId = dateString.substring(dateString.length() - 10);
        }
    }
}

