/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.docx.docx4j.pdf;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

public class Docx2PDFViaDocx4jConverter
extends AbstractConverterNoEntriesSupport {
    private static final Docx2PDFViaDocx4jConverter INSTANCE = new Docx2PDFViaDocx4jConverter();
    private static final Logger LOGGER = LogUtils.getLogger((String)Docx2PDFViaDocx4jConverter.class.getName());

    public static Docx2PDFViaDocx4jConverter getInstance() {
        return INSTANCE;
    }

    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)in);
            Conversion c = new Conversion(wordMLPackage);
            c.output(out, this.toPdfSettings(options));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new XDocConverterException((Throwable)e);
        }
    }

    public PdfSettings toPdfSettings(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(PdfSettings.class);
        if (value instanceof PdfSettings) {
            return (PdfSettings)value;
        }
        return new PdfSettings();
    }

    public MimeMapping getMimeMapping() {
        return MimeMappingConstants.PDF_MIME_MAPPING;
    }
}

