/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.shared.spi;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.jadira.usertype.dateandtime.shared.reflectionutils.ArrayUtils;
import org.jadira.usertype.dateandtime.shared.reflectionutils.TypeHelper;
import org.jadira.usertype.dateandtime.shared.spi.AbstractUserType;
import org.jadira.usertype.dateandtime.shared.spi.ColumnMapper;

public abstract class AbstractSingleColumnUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractUserType
implements EnhancedUserType,
Serializable {
    private static final long serialVersionUID = -8258683760413283329L;
    private final C columnMapper;
    private final int[] sqlTypes;

    public AbstractSingleColumnUserType() {
        try {
            this.columnMapper = (ColumnMapper)TypeHelper.getTypeArguments(AbstractSingleColumnUserType.class, this.getClass()).get(2).newInstance();
        }
        catch (InstantiationException ex) {
            throw new HibernateException("Could not initialise column mapper for " + this.getClass(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new HibernateException("Could not access column mapper for " + this.getClass(), (Throwable)ex);
        }
        this.sqlTypes = new int[]{this.getColumnMapper().getSqlType()};
    }

    public final C getColumnMapper() {
        return this.columnMapper;
    }

    public Class<T> returnedClass() {
        return this.getColumnMapper().returnedClass();
    }

    public final int[] sqlTypes() {
        return ArrayUtils.copyOf(this.sqlTypes);
    }

    public T nullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws SQLException {
        Object converted = this.getColumnMapper().getHibernateType().nullSafeGet(resultSet, strings[0], session, object);
        if (converted == null) {
            return null;
        }
        return this.getColumnMapper().fromNonNullValue((Object)converted);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException {
        Object transformedValue;
        if (value == null) {
            transformedValue = null;
        } else {
            Object myValue = value;
            transformedValue = this.getColumnMapper().toNonNullValue((Object)myValue);
        }
        this.getColumnMapper().getHibernateType().nullSafeSet(preparedStatement, transformedValue, index, session);
    }

    public String objectToSQLString(Object object) {
        Object myObject = object;
        Object convertedObject = myObject == null ? null : this.getColumnMapper().toNonNullValue((Object)myObject);
        return this.getColumnMapper().getHibernateType().toString(convertedObject);
    }

    public String toXMLString(Object object) {
        Object myObject = object;
        return this.getColumnMapper().toNonNullString((Object)myObject);
    }

    public T fromXMLString(String string) {
        return this.getColumnMapper().fromNonNullString(string);
    }
}

