/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public abstract class AbstractHealthIndicator
implements HealthIndicator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public final Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            this.doHealthCheck(builder);
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Health check failed", (Throwable)ex);
            builder.down(ex);
        }
        return builder.build();
    }

    protected abstract void doHealthCheck(Health.Builder var1) throws Exception;
}

