/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.net.URI;
import java.net.URISyntaxException;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.exceptions.Docx4JRuntimeException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartName
implements Comparable<PartName> {
    private static Logger log = LoggerFactory.getLogger(PartName.class);
    private URI partNameURI;
    private static String[] RFC3986_PCHAR_SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static String[] RFC3986_PCHAR_UNRESERVED_SUP = new String[]{"-", ".", "_", "~"};
    private static String[] RFC3986_PCHAR_AUTHORIZED_SUP = new String[]{":", "@"};
    private boolean isRelationship;

    public PartName(URI uri, boolean checkConformance) throws InvalidFormatException {
        if (checkConformance) {
            PartName.throwExceptionIfInvalidPartUri(uri);
        } else if (!URIHelper.PACKAGE_ROOT_URI.equals(uri)) {
            throw new Docx4JRuntimeException("OCP conformance must be check for ALL part name except special cases : ['/']");
        }
        this.partNameURI = uri;
        this.isRelationship = this.isRelationshipPartURI(this.partNameURI);
    }

    public PartName(String partName) throws InvalidFormatException {
        this(partName, true);
    }

    public PartName(String partName, boolean checkConformance) throws InvalidFormatException {
        URI partURI;
        try {
            partURI = new URI(partName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("partName argmument is not a valid OPC part name !");
        }
        if (checkConformance) {
            PartName.throwExceptionIfInvalidPartUri(partURI);
        } else if (!URIHelper.PACKAGE_ROOT_URI.equals(partURI)) {
            throw new Docx4JRuntimeException("OCP conformance must be check for ALL part name except special cases : ['/']");
        }
        this.partNameURI = partURI;
        this.isRelationship = this.isRelationshipPartURI(this.partNameURI);
    }

    private boolean isRelationshipPartURI(URI partUri) {
        if (partUri == null) {
            throw new IllegalArgumentException("partUri");
        }
        return partUri.getPath().matches(".*" + URIHelper.RELATIONSHIP_PART_SEGMENT_NAME + ".*" + URIHelper.RELATIONSHIP_PART_EXTENSION_NAME + "$");
    }

    public boolean isRelationshipPartURI() {
        return this.isRelationship;
    }

    private static void throwExceptionIfInvalidPartUri(URI partUri) throws InvalidFormatException {
        if (partUri == null) {
            throw new IllegalArgumentException("partUri");
        }
        PartName.throwExceptionIfEmptyURI(partUri);
        PartName.throwExceptionIfAbsoluteUri(partUri);
        PartName.throwExceptionIfPartNameNotStartsWithForwardSlashChar(partUri);
        PartName.throwExceptionIfPartNameEndsWithForwardSlashChar(partUri);
        PartName.throwExceptionIfPartNameHaveInvalidSegments(partUri);
    }

    private static void throwExceptionIfEmptyURI(URI partURI) throws InvalidFormatException {
        if (partURI == null) {
            throw new IllegalArgumentException("partURI");
        }
        String uriPath = partURI.getPath();
        if (uriPath.length() == 0 || uriPath.length() == 1 && uriPath.charAt(0) == URIHelper.FORWARD_SLASH_CHAR) {
            throw new InvalidFormatException("A part name shall not be empty [M1.1]: " + partURI.getPath());
        }
    }

    private static void throwExceptionIfPartNameHaveInvalidSegments(URI partUri) throws InvalidFormatException {
        if (partUri == null || "".equals(partUri.toASCIIString())) {
            throw new IllegalArgumentException("partUri");
        }
        String[] segments = partUri.toASCIIString().split("/");
        if (segments.length <= 1 || !segments[0].equals("")) {
            log.error("");
            throw new InvalidFormatException("A part name shall not have empty segments [M1.3]: " + partUri.getPath());
        }
        for (int i = 1; i < segments.length; ++i) {
            String seg = segments[i];
            if (seg == null || "".equals(seg)) {
                log.error("");
                throw new InvalidFormatException("A part name shall not have empty segments [M1.3]: " + partUri.getPath());
            }
            if (seg.endsWith(".")) {
                log.error("");
                throw new InvalidFormatException("A segment shall not end with a dot ('.') character [M1.9]: " + partUri.getPath());
            }
            if ("".equals(seg.replaceAll("\\\\.", ""))) {
                log.error("");
                throw new InvalidFormatException("A segment shall include at least one non-dot character. [M1.10]: " + partUri.getPath());
            }
            PartName.checkPCharCompliance(seg);
        }
    }

    private static void checkPCharCompliance(String segment) throws InvalidFormatException {
        for (int i = 0; i < segment.length(); ++i) {
            char c = segment.charAt(i);
            boolean errorFlag = true;
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                errorFlag = false;
            } else {
                int j;
                for (j = 0; j < RFC3986_PCHAR_UNRESERVED_SUP.length; ++j) {
                    if (c != RFC3986_PCHAR_UNRESERVED_SUP[j].charAt(0)) continue;
                    errorFlag = false;
                    break;
                }
                for (j = 0; errorFlag && j < RFC3986_PCHAR_AUTHORIZED_SUP.length; ++j) {
                    if (c != RFC3986_PCHAR_AUTHORIZED_SUP[j].charAt(0)) continue;
                    errorFlag = false;
                }
                for (j = 0; errorFlag && j < RFC3986_PCHAR_SUB_DELIMS.length; ++j) {
                    if (c != RFC3986_PCHAR_SUB_DELIMS[j].charAt(0)) continue;
                    errorFlag = false;
                }
            }
            if (errorFlag && c == '%') {
                if (segment.length() - i < 2) {
                    log.error("");
                    throw new InvalidFormatException("The segment " + segment + " contain invalid encoded character !");
                }
                errorFlag = false;
                char decodedChar = (char)Integer.parseInt(segment.substring(i + 1, i + 3), 16);
                i += 2;
                if (decodedChar == '/' || decodedChar == '\\') {
                    log.error("");
                    throw new InvalidFormatException("A segment shall not contain percent-encoded forward slash ('/'), or backward slash ('') characters. [M1.7]");
                }
                if (decodedChar >= 'A' && decodedChar <= 'Z' || decodedChar >= 'a' && decodedChar <= 'z' || decodedChar >= '0' && decodedChar <= '9') {
                    errorFlag = true;
                }
                for (int j = 0; !errorFlag && j < RFC3986_PCHAR_UNRESERVED_SUP.length; ++j) {
                    if (c != RFC3986_PCHAR_UNRESERVED_SUP[j].charAt(0)) continue;
                    errorFlag = true;
                    break;
                }
                if (errorFlag) {
                    log.error("");
                    throw new InvalidFormatException("A segment shall not contain percent-encoded unreserved characters. [M1.8]");
                }
            }
            if (!errorFlag) continue;
            log.error("");
            throw new InvalidFormatException("A segment shall not hold any characters other than pchar characters. [M1.6]");
        }
    }

    private static void throwExceptionIfPartNameNotStartsWithForwardSlashChar(URI partUri) throws InvalidFormatException {
        String uriPath = partUri.getPath();
        if (uriPath.length() > 0 && uriPath.charAt(0) != URIHelper.FORWARD_SLASH_CHAR) {
            log.error("");
            throw new InvalidFormatException("A part name shall start with a forward slash ('/') character [M1.4]: " + partUri.getPath());
        }
    }

    private static void throwExceptionIfPartNameEndsWithForwardSlashChar(URI partUri) throws InvalidFormatException {
        String uriPath = partUri.getPath();
        if (uriPath.length() > 0 && uriPath.charAt(uriPath.length() - 1) == URIHelper.FORWARD_SLASH_CHAR) {
            log.error("");
            throw new InvalidFormatException("A part name shall not have a forward slash as the last character [M1.5]: " + partUri.getPath());
        }
    }

    private static void throwExceptionIfAbsoluteUri(URI partUri) throws InvalidFormatException {
        if (partUri.isAbsolute()) {
            log.error("");
            throw new InvalidFormatException("Absolute URI forbidden: " + partUri);
        }
    }

    @Override
    public int compareTo(PartName otherPartName) {
        if (otherPartName == null) {
            return -1;
        }
        return this.partNameURI.toASCIIString().toLowerCase().compareTo(otherPartName.partNameURI.toASCIIString().toLowerCase());
    }

    public String getExtension() {
        int i;
        String fragment = this.partNameURI.getPath();
        if (fragment.length() > 0 && (i = fragment.lastIndexOf(".")) > -1) {
            return fragment.substring(i + 1);
        }
        return "";
    }

    public String getName() {
        return this.partNameURI.toASCIIString();
    }

    public boolean equals(Object otherPartName) {
        if (otherPartName == null || !(otherPartName instanceof PartName)) {
            return false;
        }
        return this.partNameURI.toASCIIString().toLowerCase().equals(((PartName)otherPartName).partNameURI.toASCIIString().toLowerCase());
    }

    public int hashCode() {
        return this.partNameURI.toASCIIString().toLowerCase().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public URI getURI() {
        return this.partNameURI;
    }

    public static String generateUniqueName(Base sourcePart, String proposedRelId, String directoryPrefix, String after_, String ext) {
        String sourcepartName = sourcePart.getPartName().getName();
        int beginIndex = sourcepartName.lastIndexOf("/") + 1;
        int endIndex = sourcepartName.lastIndexOf(".");
        String partPrefix = sourcepartName.substring(beginIndex, endIndex);
        return directoryPrefix + partPrefix + "_" + after_ + "_" + proposedRelId + "." + ext;
    }

    public static String getRelationshipsPartName(String partName) {
        Object relationshipsPartName = null;
        String rightBit = partName;
        int pos = partName.lastIndexOf("/");
        if (pos > 0) {
            String leftBit = partName.substring(0, pos);
            rightBit = partName.substring(pos);
            return leftBit + "/_rels" + rightBit + ".rels";
        }
        if (!rightBit.startsWith("/")) {
            rightBit = "/" + rightBit;
        }
        return "/_rels" + rightBit + ".rels";
    }
}

