/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MetaClass;
import groovy.transform.builder.Builder;
import groovy.transform.builder.SimpleStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.FetchType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.config.Property;
import org.grails.orm.hibernate.cfg.CacheConfig;
import org.grails.orm.hibernate.cfg.ColumnConfig;
import org.grails.orm.hibernate.cfg.JoinTable;
import org.grails.orm.hibernate.cfg.Table;
import org.hibernate.FetchMode;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.DataBinder;

@Builder(prefix="", builderStrategy=SimpleStrategy.class)
public class PropertyConfig
extends Property {
    boolean firstColumnIsColumnCopy;
    private boolean explicitSaveUpdateCascade;
    private Object type;
    private Properties typeParams;
    private String sort;
    private String order;
    private Integer batchSize;
    private boolean ignoreNotFound;
    private boolean insertable;
    private boolean updatable;
    private List<ColumnConfig> columns;
    private CacheConfig cache;
    private JoinTable joinTable;
    private PropertyConfig indexColumn;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PropertyConfig() {
        JoinTable joinTable;
        List list;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        this.firstColumnIsColumnCopy = bl4 = false;
        this.ignoreNotFound = bl3 = false;
        this.insertable = bl2 = true;
        this.updatable = bl = true;
        this.columns = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.joinTable = joinTable = new JoinTable();
        this.setFetchStrategy(null);
    }

    @Deprecated
    public boolean getUpdateable() {
        return this.updatable;
    }

    @Deprecated
    public void setUpdateable(boolean updateable) {
        boolean bl;
        this.updatable = bl = updateable;
    }

    public PropertyConfig column(@DelegatesTo(value=ColumnConfig.class) Closure columnDef) {
        if (this.columns.size() == 1 && this.firstColumnIsColumnCopy) {
            boolean bl;
            this.firstColumnIsColumnCopy = bl = false;
            ColumnConfig.configureExisting((ColumnConfig)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.columns, (int)0), ColumnConfig.class), columnDef);
        } else {
            this.columns.add(ColumnConfig.configureNew(columnDef));
        }
        return this;
    }

    public PropertyConfig column(Map columnDef) {
        if (this.columns.size() == 1 && this.firstColumnIsColumnCopy) {
            boolean bl;
            this.firstColumnIsColumnCopy = bl = false;
            ColumnConfig.configureExisting((ColumnConfig)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.columns, (int)0), ColumnConfig.class), columnDef);
        } else {
            this.columns.add(ColumnConfig.configureNew(columnDef));
        }
        return this;
    }

    public PropertyConfig column(String columnDef) {
        if (this.columns.size() == 1 && this.firstColumnIsColumnCopy) {
            boolean bl;
            this.firstColumnIsColumnCopy = bl = false;
            String string = columnDef;
            ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).setName(string);
        } else {
            this.columns.add(ColumnConfig.configureNew(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", columnDef})));
        }
        return this;
    }

    public PropertyConfig cache(@DelegatesTo(value=CacheConfig.class) Closure cacheConfig) {
        if (this.cache == null) {
            CacheConfig cacheConfig2;
            this.cache = cacheConfig2 = new CacheConfig();
        }
        CacheConfig.configureExisting(this.cache, cacheConfig);
        return this;
    }

    public PropertyConfig cache(Map cacheConfig) {
        if (this.cache == null) {
            CacheConfig cacheConfig2;
            this.cache = cacheConfig2 = new CacheConfig();
        }
        CacheConfig.configureExisting(this.cache, cacheConfig);
        return this;
    }

    public PropertyConfig joinTable(@DelegatesTo(value=JoinTable.class) Closure joinTableDef) {
        Table.configureExisting((Table)this.joinTable, joinTableDef);
        return this;
    }

    public PropertyConfig joinTable(String tableName) {
        String string = tableName;
        this.joinTable.setName(string);
        return this;
    }

    public void setUnique(boolean unique) {
        super.setUnique(unique);
        if (this.columns.size() == 1) {
            boolean bl = unique;
            ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).setUnique(bl);
        }
    }

    public PropertyConfig joinTable(Map joinTableDef) {
        DataBinder dataBinder = new DataBinder((Object)this.joinTable);
        dataBinder.bind((PropertyValues)new MutablePropertyValues(joinTableDef));
        if (DefaultTypeTransformation.booleanUnbox(joinTableDef.get("key"))) {
            this.joinTable.key(DefaultGroovyMethods.toString(joinTableDef.get("key")));
        }
        if (DefaultTypeTransformation.booleanUnbox(joinTableDef.get("column"))) {
            this.joinTable.column(DefaultGroovyMethods.toString(joinTableDef.get("column")));
        }
        return this;
    }

    public void setFetch(FetchMode fetch) {
        if (FetchMode.JOIN.equals((Object)fetch)) {
            super.setFetchStrategy(FetchType.EAGER);
        } else {
            super.setFetchStrategy(FetchType.LAZY);
        }
    }

    public FetchMode getFetchMode() {
        FetchType strategy = super.getFetchStrategy();
        if (strategy == null) {
            return FetchMode.DEFAULT;
        }
        FetchType fetchType = strategy;
        if (ScriptBytecodeAdapter.isCase((Object)fetchType, (Object)FetchType.EAGER)) {
            return FetchMode.JOIN;
        }
        if (ScriptBytecodeAdapter.isCase((Object)fetchType, (Object)FetchType.LAZY)) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    public PropertyConfig indexColumn(@DelegatesTo(value=PropertyConfig.class) Closure indexColumnConfig) {
        PropertyConfig propertyConfig;
        this.indexColumn = propertyConfig = PropertyConfig.configureNew(indexColumnConfig);
        return this;
    }

    public static PropertyConfig configureNew(@DelegatesTo(value=PropertyConfig.class) Closure config) {
        PropertyConfig property = new PropertyConfig();
        return PropertyConfig.configureExisting(property, config);
    }

    public static PropertyConfig configureNew(Map config) {
        PropertyConfig property = new PropertyConfig();
        return PropertyConfig.configureExisting(property, config);
    }

    public static PropertyConfig configureExisting(PropertyConfig property, Map config) {
        DataBinder dataBinder = new DataBinder((Object)property);
        dataBinder.bind((PropertyValues)new MutablePropertyValues(config));
        ColumnConfig cc = null;
        if (DefaultTypeTransformation.booleanUnbox(property.getColumns())) {
            Object object = DefaultGroovyMethods.getAt(property.getColumns(), (int)0);
            cc = (ColumnConfig)ScriptBytecodeAdapter.castToType((Object)object, ColumnConfig.class);
        } else {
            ColumnConfig columnConfig;
            cc = columnConfig = new ColumnConfig();
            property.getColumns().add(cc);
        }
        if (DefaultTypeTransformation.booleanUnbox(config.get("column"))) {
            Object v = config.get("column");
            ScriptBytecodeAdapter.setProperty(v, null, (Object)config, (String)"name");
        }
        ColumnConfig.configureExisting(cc, config);
        return property;
    }

    public static PropertyConfig configureExisting(PropertyConfig property, @DelegatesTo(value=PropertyConfig.class) Closure config) {
        config.setDelegate((Object)property);
        config.setResolveStrategy(Closure.DELEGATE_ONLY);
        config.call();
        return property;
    }

    public String getColumn() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return ShortTypeHandling.castToString(null);
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getName();
    }

    public String getEnumType() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return "default";
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getEnumType();
    }

    public String getSqlType() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return ShortTypeHandling.castToString(null);
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getSqlType();
    }

    public String getIndexName() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return ShortTypeHandling.castToString(null);
        }
        Object object = ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getIndex();
        return object != null ? DefaultGroovyMethods.toString((Object)object) : null;
    }

    public boolean isUnique() {
        if (this.columns.size() > 1) {
            return super.isUnique();
        }
        if (this.columns.isEmpty()) {
            return super.isUnique();
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getUnique();
    }

    public int getLength() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return -1;
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getLength();
    }

    public int getPrecision() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return -1;
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getPrecision();
    }

    public int getScale() {
        this.checkHasSingleColumn();
        if (this.columns.isEmpty()) {
            return super.getScale();
        }
        return ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).getScale();
    }

    public void setScale(int scale) {
        this.checkHasSingleColumn();
        if (!this.columns.isEmpty()) {
            int n = scale;
            ((ColumnConfig)DefaultGroovyMethods.getAt(this.columns, (int)0)).setScale(n);
        } else {
            super.setScale(scale);
        }
    }

    public String toString() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.type, this.getLazy(), this.columns, this.insertable, this.updatable}, new String[]{"property[type:", ", lazy:", ", columns:", ", insertable:", ", updateable:", "]"}));
    }

    protected void checkHasSingleColumn() {
        List<ColumnConfig> list = this.columns;
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
            throw (Throwable)new RuntimeException("Cannot treat multi-column property as a single-column property");
        }
    }

    public PropertyConfig clone() throws CloneNotSupportedException {
        PropertyConfig pc = (PropertyConfig)((Object)ScriptBytecodeAdapter.castToType((Object)super.clone(), PropertyConfig.class));
        FetchMode fetchMode = this.getFetchMode();
        pc.setFetch(fetchMode);
        PropertyConfig propertyConfig = this.indexColumn != null ? this.indexColumn.clone() : null;
        pc.setIndexColumn((PropertyConfig)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)propertyConfig), PropertyConfig.class)));
        CacheConfig cacheConfig = this.cache != null ? this.cache.clone() : this.cache;
        pc.setCache(cacheConfig);
        JoinTable joinTable = this.joinTable.clone();
        pc.setJoinTable(joinTable);
        if (this.typeParams != null) {
            Properties properties = new Properties(this.typeParams);
            pc.setTypeParams(properties);
        }
        ArrayList<ColumnConfig> newColumns = new ArrayList<ColumnConfig>(this.columns.size());
        ArrayList<ColumnConfig> arrayList = newColumns;
        pc.setColumns(arrayList);
        ColumnConfig c = null;
        Iterator<ColumnConfig> iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            c = (ColumnConfig)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ColumnConfig.class);
            newColumns.add(c.clone());
        }
        return pc;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PropertyConfig.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public PropertyConfig firstColumnIsColumnCopy(boolean firstColumnIsColumnCopy) {
        boolean bl;
        this.firstColumnIsColumnCopy = bl = firstColumnIsColumnCopy;
        return this;
    }

    public PropertyConfig explicitSaveUpdateCascade(boolean explicitSaveUpdateCascade) {
        boolean bl;
        this.explicitSaveUpdateCascade = bl = explicitSaveUpdateCascade;
        return this;
    }

    public PropertyConfig type(Object type) {
        Object object;
        this.type = object = type;
        return this;
    }

    public PropertyConfig typeParams(Properties typeParams) {
        Properties properties;
        this.typeParams = properties = typeParams;
        return this;
    }

    public PropertyConfig sort(String sort) {
        String string;
        this.sort = string = sort;
        return this;
    }

    public PropertyConfig order(String order) {
        String string;
        this.order = string = order;
        return this;
    }

    public PropertyConfig batchSize(Integer batchSize) {
        Integer n;
        this.batchSize = n = batchSize;
        return this;
    }

    public PropertyConfig ignoreNotFound(boolean ignoreNotFound) {
        boolean bl;
        this.ignoreNotFound = bl = ignoreNotFound;
        return this;
    }

    public PropertyConfig insertable(boolean insertable) {
        boolean bl;
        this.insertable = bl = insertable;
        return this;
    }

    public PropertyConfig updatable(boolean updatable) {
        boolean bl;
        this.updatable = bl = updatable;
        return this;
    }

    public PropertyConfig columns(List<ColumnConfig> columns) {
        List<ColumnConfig> list = columns;
        this.columns = list;
        return this;
    }

    public PropertyConfig cache(CacheConfig cache) {
        CacheConfig cacheConfig;
        this.cache = cacheConfig = cache;
        return this;
    }

    public PropertyConfig joinTable(JoinTable joinTable) {
        JoinTable joinTable2;
        this.joinTable = joinTable2 = joinTable;
        return this;
    }

    public PropertyConfig indexColumn(PropertyConfig indexColumn) {
        PropertyConfig propertyConfig;
        this.indexColumn = propertyConfig = indexColumn;
        return this;
    }

    public boolean getExplicitSaveUpdateCascade() {
        return this.explicitSaveUpdateCascade;
    }

    public boolean isExplicitSaveUpdateCascade() {
        return this.explicitSaveUpdateCascade;
    }

    public void setExplicitSaveUpdateCascade(boolean bl) {
        this.explicitSaveUpdateCascade = bl;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object object) {
        this.type = object;
    }

    public Properties getTypeParams() {
        return this.typeParams;
    }

    public void setTypeParams(Properties properties) {
        this.typeParams = properties;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String string) {
        this.sort = string;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String string) {
        this.order = string;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer n) {
        this.batchSize = n;
    }

    public boolean getIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean bl) {
        this.ignoreNotFound = bl;
    }

    public boolean getInsertable() {
        return this.insertable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public boolean getUpdatable() {
        return this.updatable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean bl) {
        this.updatable = bl;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> list) {
        this.columns = list;
    }

    public CacheConfig getCache() {
        return this.cache;
    }

    public void setCache(CacheConfig cacheConfig) {
        this.cache = cacheConfig;
    }

    public JoinTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(JoinTable joinTable) {
        this.joinTable = joinTable;
    }

    public PropertyConfig getIndexColumn() {
        return this.indexColumn;
    }

    public void setIndexColumn(PropertyConfig propertyConfig) {
        this.indexColumn = propertyConfig;
    }
}

