/*
 * Decompiled with CFR 0.152.
 */
package eu.bitwalker.useragentutils;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.Version;
import java.io.Serializable;

public class UserAgent
implements Serializable {
    private static final long serialVersionUID = 7025462762784240212L;
    private OperatingSystem operatingSystem;
    private Browser browser;
    private int id;
    private String userAgentString;

    @Deprecated
    public UserAgent() {
        this(OperatingSystem.UNKNOWN, Browser.UNKNOWN);
    }

    public UserAgent(OperatingSystem operatingSystem, Browser browser) {
        this.operatingSystem = operatingSystem;
        this.browser = browser;
        this.id = (operatingSystem.getId() << 16) + browser.getId();
    }

    public UserAgent(String userAgentString) {
        String userAgentLowercaseString = userAgentString == null ? null : userAgentString.toLowerCase();
        Browser browser = Browser.parseUserAgentLowercaseString(userAgentLowercaseString);
        OperatingSystem operatingSystem = OperatingSystem.UNKNOWN;
        if (browser != Browser.BOT) {
            operatingSystem = OperatingSystem.parseUserAgentLowercaseString(userAgentLowercaseString);
        }
        this.operatingSystem = operatingSystem;
        this.browser = browser;
        this.id = (operatingSystem.getId() << 16) + browser.getId();
        this.userAgentString = userAgentString;
    }

    public static UserAgent parseUserAgentString(String userAgentString) {
        return new UserAgent(userAgentString);
    }

    public Version getBrowserVersion() {
        return this.browser.getVersion(this.userAgentString);
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.operatingSystem.toString() + "-" + this.browser.toString();
    }

    public static UserAgent valueOf(int id) {
        OperatingSystem operatingSystem = OperatingSystem.valueOf((short)(id >> 16));
        Browser browser = Browser.valueOf((short)(id & 0xFFFF));
        return new UserAgent(operatingSystem, browser);
    }

    public static UserAgent valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        String[] elements = name.split("-");
        if (elements.length == 2) {
            OperatingSystem operatingSystem = OperatingSystem.valueOf(elements[0]);
            Browser browser = Browser.valueOf(elements[1]);
            return new UserAgent(operatingSystem, browser);
        }
        throw new IllegalArgumentException("Invalid string for userAgent " + name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browser == null ? 0 : this.browser.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)obj;
        if (this.browser == null ? other.browser != null : !this.browser.equals((Object)other.browser)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return !(this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals((Object)other.operatingSystem));
    }
}

