/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.shared.temporaltype.descriptor.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;

public class LocationSafeTimeTypeDescriptor
extends TimeTypeDescriptor {
    private static final long serialVersionUID = 2320271428720185601L;
    public static final TimeTypeDescriptor INSTANCE = new LocationSafeTimeTypeDescriptor();

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setTime(index, (Time)javaTypeDescriptor.unwrap(value, Time.class, options), LocationSafeTimeTypeDescriptor.this.getUtcCalendar());
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)rs.getTime(name, LocationSafeTimeTypeDescriptor.this.getUtcCalendar()), options);
            }
        };
    }

    protected final Calendar getUtcCalendar() {
        Calendar utcCalendar = Calendar.getInstance();
        utcCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcCalendar;
    }
}

