/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.CellCoverInfo;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWrapOptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencySymbolElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.type.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OdfTableCell {
    TableTableCellElementBase mOdfElement;
    int mnRepeatedColIndex;
    int mnRepeatedRowIndex;
    OdfTable mOwnerTable;
    String msFormatString;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "'PT'HH'H'mm'M'ss'S'";
    private static final String DEFAULT_BACKGROUND_COLOR = "#FFFFFF";
    private static final int DEFAULT_COLUMN_SPANNED_NUMBER = 1;
    private static final int DEFAULT_ROW_SPANNED_NUMBER = 1;
    private static final int DEFAULT_COLUMNS_REPEATED_NUMBER = 1;
    TableTableCellElementBase mCellElement;
    OdfDocument mDocument;

    OdfTableCell(TableTableCellElementBase odfElement, int repeatedColIndex, int repeatedRowIndex) {
        this.mCellElement = odfElement;
        this.mnRepeatedColIndex = repeatedColIndex;
        this.mnRepeatedRowIndex = repeatedRowIndex;
        this.mOwnerTable = this.getTable();
        this.mDocument = (OdfDocument)((OdfFileDom)((Object)this.mCellElement.getOwnerDocument())).getDocument();
    }

    public static OdfTableCell getInstance(TableTableCellElementBase cellElement) {
        TableTableElement tableElement = null;
        for (Node node = cellElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)((Object)node);
        }
        OdfTable table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the cellElement is not in the table dom tree");
        }
        table = OdfTable.getInstance(tableElement);
        OdfTableCell cell = table.getCellInstance(cellElement, 0, 0);
        int colRepeatedNum = cell.getColumnsRepeatedNumber();
        int rowRepeatedNum = cell.getTableRow().getRowsRepeatedNumber();
        if (colRepeatedNum > 1 && rowRepeatedNum > 1) {
            if (colRepeatedNum > 1) {
                Logger.getLogger(OdfTableCell.class.getName()).log(Level.WARNING, "the cell has the repeated column number, and puzzled about get which repeated column index of the cell,");
            }
            if (rowRepeatedNum > 1) {
                Logger.getLogger(OdfTableCell.class.getName()).log(Level.WARNING, "the row contains the current cell has the repeated row number, and puzzled about get which repeated row index of the cell,");
            }
            Logger.getLogger(OdfTableCell.class.getName()).log(Level.WARNING, "here just return the first cell that the repeated column index is 0 and repeated row index is 0, too.");
        }
        return cell;
    }

    public String getHorizontalAlignment() {
        OdfStyle styleElement = this.getCellStyleElement();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfDocumentNamespace.FO, "text-align"));
            return styleElement.getProperty(property);
        }
        return null;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        if (FoTextAlignAttribute.Value.LEFT.toString().equalsIgnoreCase(horizontalAlignment)) {
            horizontalAlignment = FoTextAlignAttribute.Value.START.toString();
        }
        if (FoTextAlignAttribute.Value.RIGHT.toString().equalsIgnoreCase(horizontalAlignment)) {
            horizontalAlignment = FoTextAlignAttribute.Value.END.toString();
        }
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfDocumentNamespace.FO, "text-align"));
            if (horizontalAlignment != null) {
                styleElement.setProperty(property, horizontalAlignment);
            } else {
                styleElement.removeProperty(property);
            }
        }
    }

    public String getVerticalAlignment() {
        OdfStyle styleElement = this.getCellStyleElement();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "vertical-align"));
            return styleElement.getProperty(property);
        }
        return null;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "vertical-align"));
            if (verticalAlignment != null) {
                styleElement.setProperty(property, verticalAlignment);
            } else {
                styleElement.removeProperty(property);
            }
        }
    }

    public boolean isTextWrapped() {
        OdfStyleProperty property;
        String wrapped;
        OdfStyle styleElement = this.getCellStyleElement();
        return styleElement != null && (wrapped = styleElement.getProperty(property = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "wrap-option")))) != null && wrapped.equals(FoWrapOptionAttribute.Value.WRAP.toString());
    }

    public void setTextWrapped(boolean isTextWrapped) {
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "wrap-option"));
            if (isTextWrapped) {
                styleElement.setProperty(property, FoWrapOptionAttribute.Value.WRAP.toString());
            } else {
                styleElement.setProperty(property, FoWrapOptionAttribute.Value.NO_WRAP.toString());
            }
        }
    }

    private TableTableRowElement findRowInTableHeaderRows(TableTableHeaderRowsElement headers, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        for (Node m : new DomNodeList(headers.getChildNodes())) {
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            result += ((TableTableRowElement)((Object)m)).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    private TableTableRowElement findRowInTableRows(TableTableRowsElement rows, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        for (Node m : new DomNodeList(rows.getChildNodes())) {
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            result += ((TableTableRowElement)((Object)m)).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    private TableTableRowElement findRowInTableRowGroup(OdfElement group, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        int[] resultIndexs = new int[1];
        if (!(group instanceof TableTableRowGroupElement) && !(group instanceof TableTableElement)) {
            indexs[0] = 0;
            return null;
        }
        for (Node m : new DomNodeList(group.getChildNodes())) {
            TableTableRowElement returnEle;
            if (m instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)((Object)m);
                returnEle = this.findRowInTableHeaderRows(headers, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (m instanceof TableTableRowGroupElement) {
                TableTableRowGroupElement aGroup = (TableTableRowGroupElement)((Object)m);
                returnEle = this.findRowInTableRowGroup(aGroup, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (m instanceof TableTableRowsElement) {
                TableTableRowsElement rows = (TableTableRowsElement)((Object)m);
                returnEle = this.findRowInTableRows(rows, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            result += ((TableTableRowElement)((Object)m)).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    public int getRowIndex() {
        int[] indexs;
        TableTableRowElement tr;
        TableTableElement table = this.getTableElement();
        TableTableRowElement returnEle = this.findRowInTableRowGroup(table, tr = this.getTableRowElement(), indexs = new int[1]);
        if (returnEle != null) {
            return indexs[0] + this.mnRepeatedRowIndex;
        }
        return -1;
    }

    public OdfTable getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return OdfTable.getInstance(tableElement);
        }
        return null;
    }

    public int getColumnIndex() {
        TableTableRowElement tr = (TableTableRowElement)((Object)this.mCellElement.getParentNode());
        int result = 0;
        for (Node n : new DomNodeList(tr.getChildNodes())) {
            if (n == this.mCellElement) {
                return result + this.mnRepeatedColIndex;
            }
            if (!(n instanceof TableTableCellElementBase)) continue;
            result += ((TableTableCellElementBase)((Object)n)).getTableNumberColumnsRepeatedAttribute().intValue();
        }
        return result;
    }

    public OdfTableColumn getTableColumn() {
        OdfTable table = this.getTable();
        int index = this.getColumnIndex();
        return table.getColumnByIndex(index);
    }

    TableTableColumnElement getTableColumnElement() {
        TableTableElement tableElement = this.getTableElement();
        int columnindex = this.getColumnIndex();
        OdfTable fTable = OdfTable.getInstance(tableElement);
        return fTable.getColumnElementByIndex(columnindex);
    }

    public OdfTableRow getTableRow() {
        OdfTable table = this.getTable();
        int index = this.getRowIndex();
        return table.getRowByIndex(index);
    }

    private TableTableRowElement getTableRowElement() {
        Node node = this.mCellElement.getParentNode();
        if (node instanceof TableTableRowElement) {
            return (TableTableRowElement)((Object)node);
        }
        return null;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.mCellElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)((Object)node);
        }
        return null;
    }

    public OdfTableCell getOwnerTableCell() {
        OdfTable ownerTable = this.getTable();
        List<CellCoverInfo> coverList = ownerTable.getCellCoverInfos(0, 0, ownerTable.getColumnCount() - 1, ownerTable.getRowCount() - 1);
        return ownerTable.getOwnerCellByPosition(coverList, this.getColumnIndex(), this.getRowIndex());
    }

    public TableTableCellElementBase getOdfElement() {
        return this.mCellElement;
    }

    public String getCurrencyCode() {
        if (this.mCellElement.getOfficeValueTypeAttribute().equals(OfficeValueTypeAttribute.Value.CURRENCY.toString())) {
            return this.mCellElement.getOfficeCurrencyAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setCurrencyCode(String currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Currency code of cell should not be null.");
        }
        this.splitRepeatedCells();
        if (!this.mCellElement.getOfficeValueTypeAttribute().equals(OfficeValueTypeAttribute.Value.CURRENCY.toString())) {
            throw new IllegalArgumentException();
        }
        this.mCellElement.setOfficeCurrencyAttribute(currency);
    }

    private void setTypeAttr(OfficeValueTypeAttribute.Value type) {
        this.mCellElement.setOfficeValueTypeAttribute(type.toString());
    }

    public void setValueType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type shouldn't be null.");
        }
        String sType = type.toLowerCase();
        OfficeValueTypeAttribute.Value value = OfficeValueTypeAttribute.Value.enumValueOf(sType);
        if (value == null) {
            throw new IllegalArgumentException("the value type of cell is not valid");
        }
        this.mCellElement.setOfficeValueTypeAttribute(sType);
    }

    public String getValueType() {
        return this.mCellElement.getOfficeValueTypeAttribute();
    }

    private OfficeValueTypeAttribute.Value getTypeAttr() {
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        return OfficeValueTypeAttribute.Value.enumValueOf(type);
    }

    public Double getDoubleValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.FLOAT) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public Double getCurrencyValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.CURRENCY) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public String getCurrencySymbol() {
        if (this.getTypeAttr() != OfficeValueTypeAttribute.Value.CURRENCY) {
            throw new IllegalArgumentException();
        }
        OdfStyle style = this.getCellStyleElement();
        if (style != null) {
            String dataStyleName = style.getOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"));
            OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(dataStyleName);
            if (dataStyle == null) {
                dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(dataStyleName);
            }
            if (dataStyle != null && dataStyle.getCurrencySymbolElement() != null) {
                return dataStyle.getCurrencySymbolElement().getTextContent();
            }
        }
        return null;
    }

    public void setCurrencyValue(Double value, String currency) {
        if (currency == null) {
            throw new IllegalArgumentException("currency shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.CURRENCY);
        this.mCellElement.setOfficeValueAttribute(value);
        this.mCellElement.setOfficeCurrencyAttribute(currency);
    }

    public Double getPercentageValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setPercentageValue(Double value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.PERCENTAGE);
        this.mCellElement.setOfficeValueAttribute(value);
    }

    public String getDisplayText() {
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        return textProcessor.getText((Node)((Object)this.mCellElement));
    }

    public void setDisplayText(String content) {
        if (content == null) {
            content = "";
        }
        this.removeContent();
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        OdfTextParagraph para = new OdfTextParagraph((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()));
        textProcessor.append((Element)((Object)para), content);
        this.mCellElement.appendChild((Node)((Object)para));
    }

    public void setDisplayText(String content, String stylename) {
        if (content == null) {
            content = "";
        }
        this.removeContent();
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        OdfTextParagraph para = new OdfTextParagraph((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()));
        if (stylename != null && stylename.length() > 0) {
            para.setStyleName(stylename);
        }
        textProcessor.append((Element)((Object)para), content);
        this.mCellElement.appendChild((Node)((Object)para));
    }

    public void setDoubleValue(Double value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.FLOAT);
        this.mCellElement.setOfficeValueAttribute(value);
        this.setDisplayText(value + "");
    }

    public Boolean getBooleanValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.BOOLEAN) {
            return this.mCellElement.getOfficeBooleanValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setBooleanValue(Boolean value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.BOOLEAN);
        this.mCellElement.setOfficeBooleanValueAttribute(value);
        this.setDisplayText(value + "");
    }

    public Calendar getDateValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.DATE) {
            String dateStr = this.mCellElement.getOfficeDateValueAttribute();
            if (dateStr == null) {
                return null;
            }
            Date date = this.parseString(dateStr, DEFAULT_DATE_FORMAT);
            Calendar calender = Calendar.getInstance();
            calender.setTime(date);
            return calender;
        }
        throw new IllegalArgumentException();
    }

    public void setDateValue(Calendar date) {
        if (date == null) {
            throw new IllegalArgumentException("date shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.DATE);
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String svalue = simpleFormat.format(date.getTime());
        this.mCellElement.setOfficeDateValueAttribute(svalue);
        this.setDisplayText(svalue);
    }

    public void setStringValue(String str) {
        if (str == null) {
            str = "";
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.STRING);
        this.mCellElement.setOfficeStringValueAttribute(str);
        this.setDisplayText(str);
    }

    void splitRepeatedCells() {
        int repeateNum;
        OdfTable table = this.getTable();
        OdfTableRow row = this.getTableRow();
        int colIndex = this.getColumnIndex();
        if (row.getRowsRepeatedNumber() > 1) {
            row.splitRepeatedRows();
            OdfTableCell cell = row.getCellByIndex(colIndex);
            this.mCellElement = cell.getOdfElement();
            this.mnRepeatedColIndex = cell.mnRepeatedColIndex;
            this.mnRepeatedRowIndex = cell.mnRepeatedRowIndex;
        }
        if ((repeateNum = this.getColumnsRepeatedNumber()) > 1) {
            TableTableCellElementBase ownerCellElement = null;
            int repeatedColIndex = this.mnRepeatedColIndex;
            TableTableCellElementBase refElement = this.mCellElement;
            for (int i = repeateNum - 1; i >= 0; --i) {
                TableTableCellElementBase newCell = (TableTableCellElementBase)((Object)this.mCellElement.cloneNode(true));
                newCell.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                row.getOdfElement().insertBefore((Node)((Object)newCell), (Node)((Object)refElement));
                refElement = newCell;
                if (repeatedColIndex == i) {
                    ownerCellElement = newCell;
                    continue;
                }
                table.updateCellRepository(this.mCellElement, i, this.mnRepeatedRowIndex, newCell, 0, this.mnRepeatedRowIndex);
            }
            row.getOdfElement().removeChild((Node)((Object)this.mCellElement));
            if (ownerCellElement != null) {
                table.updateCellRepository(this.mCellElement, this.mnRepeatedColIndex, this.mnRepeatedRowIndex, ownerCellElement, 0, this.mnRepeatedRowIndex);
                this.mCellElement = ownerCellElement;
                this.mnRepeatedColIndex = 0;
            }
        }
    }

    public String getStringValue() {
        return this.getDisplayText();
    }

    public Calendar getTimeValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.TIME) {
            String timeStr = this.mCellElement.getOfficeTimeValueAttribute();
            Date date = this.parseString(timeStr, DEFAULT_TIME_FORMAT);
            Calendar calender = Calendar.getInstance();
            calender.setTime(date);
            calender.clear(1);
            calender.clear(2);
            calender.clear(5);
            return calender;
        }
        throw new IllegalArgumentException();
    }

    public void setTimeValue(Calendar time) {
        if (time == null) {
            throw new IllegalArgumentException("time shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.TIME);
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        String svalue = simpleFormat.format(time.getTime());
        this.mCellElement.setOfficeTimeValueAttribute(svalue);
        this.setDisplayText(svalue);
    }

    private Date parseString(String value, String format) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
        Date simpleDate = null;
        try {
            simpleDate = simpleFormat.parse(value);
        }
        catch (ParseException e) {
            Logger.getLogger(OdfTableCell.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return simpleDate;
    }

    public Color getCellBackgroundColor() {
        OdfStyleProperty bkColorProperty;
        String property;
        Color color = Color.WHITE;
        OdfStyle styleElement = this.getCellStyleElement();
        if (styleElement != null && (property = styleElement.getProperty(bkColorProperty = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "background-color")))) != null) {
            try {
                color = new Color(property);
            }
            catch (Exception e) {
                color = Color.WHITE;
                Logger.getLogger(OdfTableCell.class.getName()).log(Level.WARNING, e.getMessage());
            }
        }
        return color;
    }

    public String getCellBackgroundColorString() {
        OdfStyleProperty bkColorProperty;
        String property;
        String color = DEFAULT_BACKGROUND_COLOR;
        OdfStyle styleElement = this.getCellStyleElement();
        if (styleElement != null && Color.isValid(property = styleElement.getProperty(bkColorProperty = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "background-color"))))) {
            color = property;
        }
        return color;
    }

    public void setCellBackgroundColor(Color cellBackgroundColor) {
        if (cellBackgroundColor == null) {
            cellBackgroundColor = Color.WHITE;
        }
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty bkColorProperty = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "background-color"));
            styleElement.setProperty(bkColorProperty, cellBackgroundColor.toString());
        }
    }

    public void setCellBackgroundColor(String cellBackgroundColor) {
        if (!Color.isValid(cellBackgroundColor)) {
            Logger.getLogger(OdfTableCell.class.getName()).log(Level.WARNING, "Parameter is invalid for datatype Color, default background color #FFFFFF will be set.");
            cellBackgroundColor = DEFAULT_BACKGROUND_COLOR;
        }
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty bkColorProperty = OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.newName(OdfDocumentNamespace.FO, "background-color"));
            styleElement.setProperty(bkColorProperty, cellBackgroundColor);
        }
    }

    int getColumnSpannedNumber() {
        if (this.mCellElement instanceof TableCoveredTableCellElement) {
            return 1;
        }
        Integer value = ((TableTableCellElement)this.mCellElement).getTableNumberColumnsSpannedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    int getColumnsRepeatedNumber() {
        Integer value = this.mCellElement.getTableNumberColumnsRepeatedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    int getRowSpannedNumber() {
        if (this.mCellElement instanceof TableCoveredTableCellElement) {
            return 1;
        }
        Integer value = ((TableTableCellElement)this.mCellElement).getTableNumberRowsSpannedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    void setColumnSpannedNumber(int spannedNum) {
        if (spannedNum < 1) {
            spannedNum = 1;
        }
        this.splitRepeatedCells();
        if (!(this.mCellElement instanceof TableTableCellElement)) {
            throw new IllegalArgumentException();
        }
        ((TableTableCellElement)this.mCellElement).setTableNumberColumnsSpannedAttribute(new Integer(spannedNum));
    }

    void setColumnsRepeatedNumber(int repeatedNum) {
        if (repeatedNum < 1) {
            repeatedNum = 1;
        }
        this.mCellElement.setTableNumberColumnsRepeatedAttribute(new Integer(repeatedNum));
    }

    void setRowSpannedNumber(int spannedNum) {
        if (spannedNum < 1) {
            spannedNum = 1;
        }
        this.splitRepeatedCells();
        if (!(this.mCellElement instanceof TableTableCellElement)) {
            throw new IllegalArgumentException();
        }
        ((TableTableCellElement)this.mCellElement).setTableNumberRowsSpannedAttribute(new Integer(spannedNum));
    }

    boolean isCoveredElement() {
        return this.mCellElement instanceof TableCoveredTableCellElement;
    }

    public String getStyleName() {
        OdfStyle style = this.getCellStyleElement();
        if (style == null) {
            return "";
        }
        return style.getStyleNameAttribute();
    }

    public void setFormula(String formula) {
        if (formula == null) {
            throw new IllegalArgumentException("formula shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.mCellElement.setTableFormulaAttribute(formula);
    }

    public String getFormula() {
        return this.mCellElement.getTableFormulaAttribute();
    }

    public void setCurrencyFormat(String currencySymbol, String format) {
        if (currencySymbol == null) {
            throw new IllegalArgumentException("currencySymbol shouldn't be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("format shouldn't be null.");
        }
        this.splitRepeatedCells();
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        OfficeValueTypeAttribute.Value typeValue = null;
        this.msFormatString = format;
        if (type != null) {
            typeValue = OfficeValueTypeAttribute.Value.enumValueOf(type);
        }
        if (typeValue != OfficeValueTypeAttribute.Value.CURRENCY) {
            throw new IllegalArgumentException();
        }
        OdfNumberCurrencyStyle currencyStyle = new OdfNumberCurrencyStyle((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()), currencySymbol, format, this.getUniqueCurrencyStyleName());
        this.mCellElement.getAutomaticStyles().appendChild((Node)((Object)currencyStyle));
        this.setDataDisplayStyleName(currencyStyle.getStyleNameAttribute());
        Double value = this.getCurrencyValue();
        if (value != null) {
            this.setDisplayText(this.formatCurrency(currencyStyle, value));
        }
    }

    private String formatCurrency(OdfNumberCurrencyStyle currencyStyle, double value) {
        String valuestr = "";
        for (Node m : new DomNodeList(currencyStyle.getChildNodes())) {
            if (m instanceof NumberCurrencySymbolElement) {
                valuestr = valuestr + m.getTextContent();
                continue;
            }
            if (m instanceof NumberNumberElement) {
                String numberformat = currencyStyle.getNumberFormat();
                valuestr = valuestr + new DecimalFormat(numberformat).format(value);
                continue;
            }
            if (!(m instanceof NumberTextElement)) continue;
            String textcontent = m.getTextContent();
            if (textcontent == null || textcontent.length() == 0) {
                textcontent = " ";
            }
            valuestr = valuestr + textcontent;
        }
        return valuestr;
    }

    public void setFormatString(String formatStr) {
        if (formatStr == null) {
            throw new IllegalArgumentException("formatStr shouldn't be null.");
        }
        String type = this.getValueType();
        if (type == null) {
            if (formatStr.contains("%")) {
                this.setValueType("percentage");
            } else if (formatStr.contains("H") || formatStr.contains("k") || formatStr.contains("m") || formatStr.contains("s") || formatStr.contains("S")) {
                this.setValueType("time");
            } else if (formatStr.contains("y") || formatStr.contains("M") || formatStr.contains("w") || formatStr.contains("W") || formatStr.contains("D") || formatStr.contains("d") || formatStr.contains("F") || formatStr.contains("E") || formatStr.contains("K") || formatStr.contains("h")) {
                this.setValueType("date");
            } else if (formatStr.contains("#") || formatStr.contains("0")) {
                this.setValueType("float");
            } else {
                throw new UnsupportedOperationException("format string: " + formatStr + " can't be adapted to a possible value type.");
            }
            type = this.getValueType();
        }
        this.setCellFormatString(formatStr, type);
    }

    private void setCellFormatString(String formatStr, String type) {
        OfficeValueTypeAttribute.Value typeValue = null;
        this.msFormatString = formatStr;
        this.splitRepeatedCells();
        typeValue = OfficeValueTypeAttribute.Value.enumValueOf(type);
        if (typeValue == OfficeValueTypeAttribute.Value.FLOAT) {
            OdfNumberStyle numberStyle = new OdfNumberStyle((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()), formatStr, this.getUniqueNumberStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)((Object)numberStyle));
            this.setDataDisplayStyleName(numberStyle.getStyleNameAttribute());
            Double value = this.getDoubleValue();
            if (value != null) {
                this.setDisplayText(new DecimalFormat(formatStr).format(value));
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            OdfNumberDateStyle dateStyle = new OdfNumberDateStyle((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()), formatStr, this.getUniqueDateStyleName(), null);
            this.mCellElement.getAutomaticStyles().appendChild((Node)((Object)dateStyle));
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
            String dateStr = this.mCellElement.getOfficeDateValueAttribute();
            if (dateStr != null) {
                Calendar date = this.getDateValue();
                this.setDisplayText(new SimpleDateFormat(formatStr).format(date.getTime()));
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.TIME) {
            OdfNumberTimeStyle timeStyle = new OdfNumberTimeStyle((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()), formatStr, this.getUniqueDateStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)((Object)timeStyle));
            this.setDataDisplayStyleName(timeStyle.getStyleNameAttribute());
            String timeStr = this.mCellElement.getOfficeTimeValueAttribute();
            if (timeStr != null) {
                Calendar time = this.getTimeValue();
                this.setDisplayText(new SimpleDateFormat(formatStr).format(time.getTime()));
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            OdfNumberPercentageStyle dateStyle = new OdfNumberPercentageStyle((OdfFileDom)((Object)this.mCellElement.getOwnerDocument()), formatStr, this.getUniquePercentageStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)((Object)dateStyle));
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
            Double value = this.getPercentageValue();
            if (value != null) {
                this.setDisplayText(new DecimalFormat(formatStr).format(value));
            }
        } else {
            throw new IllegalArgumentException("This function doesn't support " + (Object)((Object)typeValue) + " cell.");
        }
    }

    private void setDataDisplayStyleName(String name) {
        OdfStyle styleElement = this.getCellStyleElementForWrite();
        if (styleElement != null) {
            styleElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"), name);
        }
    }

    protected OdfStyle getCellStyleElement() {
        String styleName = this.mCellElement.getStyleName();
        if (styleName == null || styleName.equals("")) {
            OdfTableRow aRow = this.getTableRow();
            styleName = aRow.getOdfElement().getTableDefaultCellStyleNameAttribute();
        }
        if (styleName == null || styleName.equals("")) {
            OdfTableColumn aColumn = this.getTableColumn();
            styleName = aColumn.getOdfElement().getTableDefaultCellStyleNameAttribute();
        }
        if (styleName == null || styleName.equals("")) {
            return null;
        }
        OdfStyle styleElement = this.mCellElement.getAutomaticStyles().getStyle(styleName, this.mCellElement.getStyleFamily());
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        if (styleElement == null) {
            styleElement = this.mCellElement.getDocumentStyle();
        }
        if (styleElement == null) {
            OdfStyle newStyle = this.mCellElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableCell);
            String newname = newStyle.getStyleNameAttribute();
            this.mCellElement.setStyleName(newname);
            newStyle.addStyleUser(this.mCellElement);
            return newStyle;
        }
        return styleElement;
    }

    protected OdfStyle getCellStyleElementForWrite() {
        boolean copy = false;
        String styleName = this.mCellElement.getStyleName();
        if (styleName == null || styleName.equals("")) {
            OdfTableRow aRow = this.getTableRow();
            styleName = aRow.getOdfElement().getTableDefaultCellStyleNameAttribute();
            copy = true;
        }
        if (styleName == null || styleName.equals("")) {
            OdfTableColumn aColumn = this.getTableColumn();
            styleName = aColumn.getOdfElement().getTableDefaultCellStyleNameAttribute();
            copy = true;
        }
        if (styleName == null || styleName.equals("")) {
            return null;
        }
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        OdfStyle styleElement = styles.getStyle(styleName, this.mCellElement.getStyleFamily());
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        if (styleElement == null) {
            styleElement = this.mCellElement.getDocumentStyle();
        }
        if (styleElement.getStyleUserCount() > 1 || copy) {
            OdfStyle newStyle = this.mCellElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableCell);
            newStyle.setProperties(styleElement.getStylePropertiesDeep());
            NamedNodeMap attributes = styleElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (attr.getNodeName().equals("style:name")) continue;
                newStyle.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
            }
            String newname = newStyle.getStyleNameAttribute();
            this.mCellElement.setStyleName(newname);
            return newStyle;
        }
        return styleElement;
    }

    private String getDataDisplayStyleName() {
        String datadisplayStylename = null;
        OdfStyle styleElement = this.getCellStyleElement();
        if (styleElement != null) {
            datadisplayStylename = styleElement.getOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"));
        }
        return datadisplayStylename;
    }

    private String getUniqueNumberStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getNumberStyle(unique_name = String.format("n%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniqueDateStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("d%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniquePercentageStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getPercentageStyle(unique_name = String.format("p%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniqueCurrencyStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getCurrencyStyle(unique_name = String.format("c%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    public String getFormatString() {
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        OfficeValueTypeAttribute.Value typeValue = null;
        if (type != null) {
            typeValue = OfficeValueTypeAttribute.Value.enumValueOf(type);
        }
        if (typeValue == OfficeValueTypeAttribute.Value.FLOAT) {
            String name = this.getDataDisplayStyleName();
            OdfNumberStyle style = this.mCellElement.getAutomaticStyles().getNumberStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getNumberStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberDateStyle style = this.mCellElement.getAutomaticStyles().getDateStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getDateStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.CURRENCY) {
            String name = this.getCurrencyDisplayStyleName();
            OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(name);
            if (dataStyle == null) {
                dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(name);
            }
            if (dataStyle != null) {
                return dataStyle.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberPercentageStyle style = this.mCellElement.getAutomaticStyles().getPercentageStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getPercentageStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        }
        return null;
    }

    private String getCurrencyDisplayStyleName() {
        String name = this.getDataDisplayStyleName();
        OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(name);
        if (dataStyle == null) {
            dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(name);
        }
        if (dataStyle != null) {
            return dataStyle.getConditionStyleName(this.getCurrencyValue());
        }
        return null;
    }

    public void removeTextContent() {
        this.splitRepeatedCells();
        Node node = this.mCellElement.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node instanceof TextPElement || node instanceof TextHElement || node instanceof TextListElement) {
                this.mCellElement.removeChild(node);
            }
            node = nextNode;
        }
    }

    public void removeContent() {
        this.splitRepeatedCells();
        Node node = this.mCellElement.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            this.mCellElement.removeChild(node);
            node = nextNode;
        }
    }

    void appendContentFrom(OdfTableCell fromCell) {
        this.splitRepeatedCells();
        OdfWhitespaceProcessor textProcess = new OdfWhitespaceProcessor();
        TableTableCellElementBase cell = fromCell.getOdfElement();
        for (Node node = cell.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof OdfTextParagraph) {
                if (textProcess.getText(node).equals("")) continue;
                this.mCellElement.appendChild(node.cloneNode(true));
                continue;
            }
            this.mCellElement.appendChild(node.cloneNode(true));
        }
    }

    OdfTableCell getCoverCell() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int i = startRowi; i >= 0; --i) {
            OdfTableRow aRow = this.mOwnerTable.getRowByIndex(i);
            for (int j = startColumni; j >= 0; --j) {
                TableTableCellElement cellEle;
                OdfTableCell cell;
                if (i == startRowi && j == startColumni || !((cell = aRow.getCellByIndex(j)).getOdfElement() instanceof TableTableCellElement) || (cellEle = (TableTableCellElement)cell.getOdfElement()).getTableNumberColumnsSpannedAttribute() + j <= startColumni || cellEle.getTableNumberRowsSpannedAttribute() + i <= startRowi) continue;
                return this.mOwnerTable.getCellInstance(cellEle, 0, 0);
            }
        }
        return null;
    }

    OdfTableCell getCoverCellInSameRow() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int j = startColumni - 1; j >= 0; --j) {
            OdfTableCell cell = this.mOwnerTable.getCellByPosition(j, startRowi);
            if (cell.getOdfElement() instanceof TableCoveredTableCellElement) continue;
            int oldSpanN = cell.getColumnSpannedNumber();
            if (oldSpanN + j > startColumni) {
                return cell;
            }
            return null;
        }
        return null;
    }

    OdfTableCell getCoverCellInSameColumn() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int i = startRowi - 1; i >= 0; --i) {
            OdfTableCell cell = this.mOwnerTable.getCellByPosition(startColumni, i);
            if (cell.getOdfElement() instanceof TableCoveredTableCellElement) continue;
            int oldSpanN = cell.getRowSpannedNumber();
            if (oldSpanN + i > startRowi) {
                return cell;
            }
            return null;
        }
        return null;
    }
}

