/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class MetricMessage {
    private static final String METRIC_NAME = "metricName";
    private static final String DELETE = "delete";
    private final Message<?> message;

    MetricMessage(Message<?> message) {
        this.message = message;
    }

    public boolean isReset() {
        return DELETE.equals(this.getPayload());
    }

    public Object getPayload() {
        return this.message.getPayload();
    }

    public String getMetricName() {
        return (String)this.message.getHeaders().get((Object)METRIC_NAME, String.class);
    }

    public static Message<?> forIncrement(Delta<?> delta) {
        return MetricMessage.forPayload(delta.getName(), delta);
    }

    public static Message<?> forSet(Metric<?> value) {
        return MetricMessage.forPayload(value.getName(), value);
    }

    public static Message<?> forReset(String metricName) {
        return MetricMessage.forPayload(metricName, DELETE);
    }

    private static Message<?> forPayload(String metricName, Object payload) {
        MessageBuilder builder = MessageBuilder.withPayload((Object)payload);
        builder.setHeader(METRIC_NAME, (Object)metricName);
        return builder.build();
    }
}

