/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class ForeignKey
extends AbstractDatabaseObject {
    public ForeignKey() {
        this.setForeignKeyColumns(new ArrayList<Column>());
        this.setPrimaryKeyColumns(new ArrayList<Column>());
    }

    public ForeignKey(String name) {
        this();
        this.setName(name);
    }

    public ForeignKey(String name, String foreignKeyCatalog, String foreignKeySchema, String foreignKeyTable, Column ... baseTableColumns) {
        this(name);
        if (foreignKeyTable != null) {
            this.setForeignKeyTable(new Table(foreignKeyCatalog, foreignKeySchema, foreignKeyTable));
        }
        if (baseTableColumns != null && baseTableColumns.length > 0 && baseTableColumns[0] != null) {
            this.setForeignKeyColumns(new ArrayList<Column>(Arrays.asList(baseTableColumns)));
        }
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        ArrayList<Column> objects = new ArrayList<Column>();
        if (this.getPrimaryKeyColumns() != null) {
            for (Column column : this.getPrimaryKeyColumns()) {
                objects.add(column);
            }
        }
        if (this.getForeignKeyColumns() != null) {
            for (Column column : this.getForeignKeyColumns()) {
                objects.add(column);
            }
        }
        return objects.toArray(new DatabaseObject[objects.size()]);
    }

    @Override
    public Schema getSchema() {
        if (this.getForeignKeyTable() == null) {
            return null;
        }
        return this.getForeignKeyTable().getSchema();
    }

    public Table getPrimaryKeyTable() {
        return (Table)((Object)this.getAttribute("primaryKeyTable", Table.class));
    }

    public ForeignKey setPrimaryKeyTable(Table primaryKeyTable) {
        this.setAttribute("primaryKeyTable", primaryKeyTable);
        return this;
    }

    public List<Column> getPrimaryKeyColumns() {
        return (List)((Object)this.getAttribute("primaryKeyColumns", List.class));
    }

    public ForeignKey setPrimaryKeyColumns(List<Column> primaryKeyColumns) {
        this.setAttribute("primaryKeyColumns", primaryKeyColumns);
        for (Column column : this.getPrimaryKeyColumns()) {
            if (column.getAttribute("relation", Object.class) != null) continue;
            column.setRelation(this.getPrimaryKeyTable());
        }
        return this;
    }

    public ForeignKey addPrimaryKeyColumn(Column primaryKeyColumn) {
        ((List)((Object)this.getAttribute("primaryKeyColumns", List.class))).add(primaryKeyColumn);
        if (primaryKeyColumn.getAttribute("relation", Object.class) == null) {
            primaryKeyColumn.setRelation(this.getPrimaryKeyTable());
        }
        return this;
    }

    public Table getForeignKeyTable() {
        return (Table)((Object)this.getAttribute("foreignKeyTable", Table.class));
    }

    public ForeignKey setForeignKeyTable(Table foreignKeyTable) {
        this.setAttribute("foreignKeyTable", foreignKeyTable);
        return this;
    }

    public List<Column> getForeignKeyColumns() {
        return (List)((Object)this.getAttribute("foreignKeyColumns", List.class));
    }

    public ForeignKey setForeignKeyColumns(List<Column> foreignKeyColumns) {
        this.setAttribute("foreignKeyColumns", foreignKeyColumns);
        for (Column column : this.getForeignKeyColumns()) {
            if (column.getAttribute("relation", Object.class) != null) continue;
            column.setRelation(this.getForeignKeyTable());
        }
        return this;
    }

    public ForeignKey addForeignKeyColumn(Column foreignKeyColumn) {
        if (foreignKeyColumn.getAttribute("relation", Object.class) == null) {
            foreignKeyColumn.setRelation(this.getForeignKeyTable());
        }
        ((List)((Object)this.getAttribute("foreignKeyColumns", List.class))).add(foreignKeyColumn);
        return this;
    }

    @Override
    public String getName() {
        return (String)((Object)this.getAttribute("name", String.class));
    }

    @Override
    public ForeignKey setName(String name) {
        this.setAttribute("name", name);
        return this;
    }

    @Override
    public String toString() {
        StringUtils.StringUtilsFormatter<Column> columnFormatter = new StringUtils.StringUtilsFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.getName();
            }
        };
        return this.getName() + "(" + this.getForeignKeyTable() + "[" + StringUtils.join(this.getForeignKeyColumns(), ", ", (StringUtils.StringUtilsFormatter)columnFormatter) + "] -> " + this.getPrimaryKeyTable() + "[" + StringUtils.join(this.getPrimaryKeyColumns(), ", ", (StringUtils.StringUtilsFormatter)columnFormatter) + "])";
    }

    public boolean isDeferrable() {
        return this.getAttribute("deferrable", false);
    }

    public ForeignKey setDeferrable(boolean deferrable) {
        this.setAttribute("deferrable", deferrable);
        return this;
    }

    public boolean isInitiallyDeferred() {
        return this.getAttribute("initiallyDeferred", false);
    }

    public ForeignKey setInitiallyDeferred(boolean initiallyDeferred) {
        this.setAttribute("initiallyDeferred", initiallyDeferred);
        return this;
    }

    public boolean shouldValidate() {
        return this.getAttribute("validate", true);
    }

    public ForeignKey setShouldValidate(boolean shouldValidate) {
        this.setAttribute("validate", shouldValidate);
        return this;
    }

    public ForeignKeyConstraintType getUpdateRule() {
        return (ForeignKeyConstraintType)((Object)this.getAttribute("updateRule", ForeignKeyConstraintType.class));
    }

    public ForeignKey setUpdateRule(ForeignKeyConstraintType rule) {
        this.setAttribute("updateRule", (Object)rule);
        return this;
    }

    public ForeignKeyConstraintType getDeleteRule() {
        return (ForeignKeyConstraintType)((Object)this.getAttribute("deleteRule", ForeignKeyConstraintType.class));
    }

    public ForeignKey setDeleteRule(ForeignKeyConstraintType rule) {
        this.setAttribute("deleteRule", (Object)rule);
        return this;
    }

    public boolean equals(Object o2) {
        boolean schemasEqual;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ForeignKey that = (ForeignKey)o2;
        if (this.getSchema() != null && that.getSchema() != null && !(schemasEqual = this.getSchema().equals(that.getSchema()))) {
            return false;
        }
        if (this.getForeignKeyColumns() == null) {
            return this.getName().equalsIgnoreCase(that.getName());
        }
        StringUtils.StringUtilsFormatter<Column> formatter = new StringUtils.StringUtilsFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.toString(false);
            }
        };
        return StringUtils.join(this.getForeignKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).equalsIgnoreCase(StringUtils.join(that.getForeignKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter)) && this.getForeignKeyTable() != null && that.getForeignKeyTable() != null && this.getForeignKeyTable().equals(that.getForeignKeyTable()) && StringUtils.join(this.getPrimaryKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).equalsIgnoreCase(StringUtils.join(that.getPrimaryKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter)) && this.getPrimaryKeyTable() != null && that.getPrimaryKeyTable() != null && this.getPrimaryKeyTable().equals(that.getPrimaryKeyTable());
    }

    public int hashCode() {
        StringUtils.StringUtilsFormatter<Column> formatter = new StringUtils.StringUtilsFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.toString(false);
            }
        };
        int result = 0;
        if (this.getPrimaryKeyTable() != null) {
            result = this.getPrimaryKeyTable().hashCode();
        }
        if (this.getPrimaryKeyColumns() != null) {
            result = 31 * result + StringUtils.join(this.getPrimaryKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).toUpperCase().hashCode();
        }
        if (this.getForeignKeyTable() != null) {
            result = 31 * result + this.getForeignKeyTable().hashCode();
        }
        if (this.getForeignKeyColumns() != null) {
            result = 31 * result + StringUtils.join(this.getForeignKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).toUpperCase().hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(Object other) {
        StringUtils.StringUtilsFormatter<Column> formatter = new StringUtils.StringUtilsFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.toString(false);
            }
        };
        ForeignKey o2 = (ForeignKey)other;
        int returnValue = 0;
        if (this.getForeignKeyTable() != null && o2.getForeignKeyTable() != null) {
            returnValue = this.getForeignKeyTable().compareTo(o2.getForeignKeyTable());
        }
        if (returnValue == 0 && this.getForeignKeyColumns() != null && o2.getForeignKeyColumns() != null) {
            returnValue = StringUtils.join(this.getForeignKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).compareToIgnoreCase(StringUtils.join(o2.getForeignKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter));
        }
        if (returnValue == 0 && this.getName() != null && o2.getName() != null) {
            returnValue = this.getName().compareToIgnoreCase(o2.getName());
        }
        if (returnValue == 0 && this.getPrimaryKeyTable() != null && o2.getPrimaryKeyTable() != null) {
            returnValue = this.getPrimaryKeyTable().compareTo(o2.getPrimaryKeyTable());
        }
        if (returnValue == 0 && this.getPrimaryKeyColumns() != null && o2.getPrimaryKeyColumns() != null) {
            returnValue = StringUtils.join(this.getPrimaryKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter).compareToIgnoreCase(StringUtils.join(o2.getPrimaryKeyColumns(), ",", (StringUtils.StringUtilsFormatter)formatter));
        }
        if (returnValue == 0 && this.getUpdateRule() != null && o2.getUpdateRule() != null) {
            returnValue = this.getUpdateRule().compareTo(o2.getUpdateRule());
        }
        if (returnValue == 0 && this.getDeleteRule() != null && o2.getDeleteRule() != null) {
            returnValue = this.getDeleteRule().compareTo(o2.getDeleteRule());
        }
        return returnValue;
    }

    private String toDisplayString(List<String> columnsNames) {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        for (String columnName : columnsNames) {
            sb.append(columnName);
            if (++i2 >= columnsNames.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Index getBackingIndex() {
        return (Index)((Object)this.getAttribute("backingIndex", Index.class));
    }

    public ForeignKey setBackingIndex(Index backingIndex) {
        this.setAttribute("backingIndex", backingIndex);
        return this;
    }
}

