/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerImpl;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.FixedSizedSchedulerImpl;
import org.mariadb.jdbc.internal.util.scheduler.MariaDbThreadFactory;

public class SchedulerServiceProviderHolder {
    public static SchedulerProvider DEFAULT_PROVIDER = new SchedulerProvider(){

        @Override
        public DynamicSizedSchedulerInterface getScheduler(int minimumThreads, String poolName, int maximumPoolSize) {
            return new DynamicSizedSchedulerImpl(minimumThreads, poolName, maximumPoolSize);
        }

        @Override
        public ScheduledThreadPoolExecutor getFixedSizeScheduler(int minimumThreads, String poolName) {
            return new FixedSizedSchedulerImpl(minimumThreads, poolName);
        }

        @Override
        public ScheduledThreadPoolExecutor getTimeoutScheduler() {
            ScheduledThreadPoolExecutor timeoutScheduler = new ScheduledThreadPoolExecutor(1, new MariaDbThreadFactory("timeout"));
            timeoutScheduler.setRemoveOnCancelPolicy(true);
            return timeoutScheduler;
        }

        @Override
        public ThreadPoolExecutor getBulkScheduler() {
            return new ThreadPoolExecutor(5, 100, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new MariaDbThreadFactory("bulk"));
        }
    };
    private static volatile SchedulerProvider currentProvider = null;

    public static void setSchedulerProvider(SchedulerProvider newProvider) {
        currentProvider = newProvider;
    }

    public static SchedulerProvider getSchedulerProvider() {
        SchedulerProvider result = currentProvider;
        if (result == null) {
            return DEFAULT_PROVIDER;
        }
        return result;
    }

    public static DynamicSizedSchedulerInterface getScheduler(int initialThreadCount, String poolName, int maximumPoolSize) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getScheduler(initialThreadCount, poolName, maximumPoolSize);
    }

    public static ScheduledExecutorService getFixedSizeScheduler(int initialThreadCount, String poolName) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getFixedSizeScheduler(initialThreadCount, poolName);
    }

    public static ScheduledExecutorService getTimeoutScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getTimeoutScheduler();
    }

    public static ThreadPoolExecutor getBulkScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getBulkScheduler();
    }

    public static interface SchedulerProvider {
        public DynamicSizedSchedulerInterface getScheduler(int var1, String var2, int var3);

        public ScheduledExecutorService getFixedSizeScheduler(int var1, String var2);

        public ScheduledThreadPoolExecutor getTimeoutScheduler();

        public ThreadPoolExecutor getBulkScheduler();
    }
}

