/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.servlet.http.Cookie;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class CookieResultMatchers {
    protected CookieResultMatchers() {
    }

    public ResultMatcher value(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "'"), (Object)cookie.getValue(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher value(final String name, final String expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie", expectedValue, cookie.getValue());
            }
        };
    }

    public ResultMatcher exists(final String name) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                CookieResultMatchers.getCookie(result, name);
            }
        };
    }

    public ResultMatcher doesNotExist(final String name) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Unexpected cookie with name '" + name + "'", cookie == null);
            }
        };
    }

    public ResultMatcher maxAge(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "' maxAge"), (Object)cookie.getMaxAge(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher maxAge(final String name, final int maxAge) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' maxAge", maxAge, cookie.getMaxAge());
            }
        };
    }

    public ResultMatcher path(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "' path"), (Object)cookie.getPath(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher path(final String name, final String path) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' path", path, cookie.getPath());
            }
        };
    }

    public ResultMatcher domain(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "' domain"), (Object)cookie.getDomain(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher domain(final String name, final String domain) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' domain", domain, cookie.getDomain());
            }
        };
    }

    public ResultMatcher comment(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "' comment"), (Object)cookie.getComment(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher comment(final String name, final String comment) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' comment", comment, cookie.getComment());
            }
        };
    }

    public ResultMatcher version(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                MatcherAssert.assertThat((String)("Response cookie '" + name + "' version"), (Object)cookie.getVersion(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher version(final String name, final int version) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' version", version, cookie.getVersion());
            }
        };
    }

    public ResultMatcher secure(final String name, final boolean secure) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' secure", secure, cookie.getSecure());
            }
        };
    }

    public ResultMatcher httpOnly(final String name, final boolean httpOnly) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Cookie cookie = CookieResultMatchers.getCookie(result, name);
                AssertionErrors.assertEquals("Response cookie '" + name + "' httpOnly", httpOnly, cookie.isHttpOnly());
            }
        };
    }

    private static Cookie getCookie(MvcResult result, String name) {
        Cookie cookie = result.getResponse().getCookie(name);
        AssertionErrors.assertTrue("No cookie with name '" + name + "'", cookie != null);
        return cookie;
    }
}

