/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.fo.FOPictWriterNoWrapImpl;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.vml.VmlShapeElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FOPictWriterFloatUsed
extends FOPictWriterNoWrapImpl {
    protected static Logger log = LoggerFactory.getLogger(FOPictWriterFloatUsed.class);

    @Override
    public Node handleVTextBoxWrapped(AbstractWmlConversionContext context, Node modelContent, Document doc, VmlShapeElements shape, Map<String, String> props) {
        log.debug("textbox - wrapped text");
        String mso_position_vertical_relative = props.get("mso-position-vertical-relative");
        String mso_position_vertical = props.get("mso-position-vertical");
        ConversionSectionWrapper csw = context.getSections().getCurrentSection();
        PageDimensions pageDimensions = csw.getPageDimensions();
        int writableWidthTwips = pageDimensions.getWritableWidthTwips();
        float writableWidthPts = writableWidthTwips / 20;
        int writableHeightTwips = pageDimensions.getWritableHeightTwips();
        float writableHeightPts = writableHeightTwips / 20;
        FORenderer foRenderer = ((FOSettings)context.getConversionSettings()).getCustomFoRenderer();
        log.debug(foRenderer.getClass().getName());
        if (mso_position_vertical_relative != null && mso_position_vertical_relative.equals("text")) {
            Element ret = doc.createElementNS(XSL_FO, "block");
            this.setBorders(ret);
            String margin_top = props.get("margin-top");
            if (margin_top == null) {
                log.error("margin top prop not found.  What to do?");
                XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                return ret;
            }
            float marginTop = this.parsePtsVal(margin_top);
            String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
            String mso_position_horizontal = props.get("mso-position-horizontal");
            float ml = this.parsePtsVal(props.get("margin-left"));
            if (mso_position_horizontal == null) {
                log.warn("No support for mso_position_horizontal==null");
                XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                return ret;
            }
            if (mso_position_horizontal.equals("absolute")) {
                log.warn("Degrading absolute position to left/right");
                mso_position_horizontal = (double)(ml / writableWidthPts) <= 0.5 ? "left" : "right";
            }
            ret = doc.createElementNS(XSL_FO, "float");
            this.setBorders(ret);
            ret.setAttribute("width", props.get("width"));
            ret.setAttribute("height", props.get("height"));
            if (mso_position_horizontal.equals("left")) {
                ret.setAttribute("float", "start");
            } else if (mso_position_horizontal.equals("center")) {
                log.warn("Degrading center to right");
                ret.setAttribute("float", "end");
            } else if (mso_position_horizontal.equals("right")) {
                ret.setAttribute("float", "end");
            }
            XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
            log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
            return ret;
        }
        if (mso_position_vertical_relative.equals("page") || mso_position_vertical_relative.equals("top-margin-area") || mso_position_vertical_relative.equals("bottom-margin-area")) {
            if (mso_position_vertical_relative.equals("page")) {
                if (mso_position_vertical.equals("top")) {
                    Element ret = doc.createElementNS(XSL_FO, "float");
                    ret.setAttribute("float", "before");
                    this.setBorders(ret);
                    log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                    return ret;
                }
                if (mso_position_vertical.equals("bottom")) {
                    Element ret = doc.createElementNS(XSL_FO, "footnote");
                    Element footnoteBody = doc.createElementNS(XSL_FO, "footnote-body");
                    ret.appendChild(footnoteBody);
                    Element block = doc.createElementNS(XSL_FO, "block");
                    footnoteBody.appendChild(block);
                    this.setBorders(block);
                    XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)block);
                    return ret;
                }
                log.warn("No support for mso_position_vertical==" + mso_position_vertical);
                return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float capable renderer, support no-wrap + mso-position-vertical=" + mso_position_vertical);
            }
            if (mso_position_vertical_relative.equals("top-margin-area")) {
                Element ret = doc.createElementNS(XSL_FO, "float");
                ret.setAttribute("float", "before");
                this.setBorders(ret);
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (mso_position_vertical_relative.equals("bottom-margin-area")) {
                Element ret = doc.createElementNS(XSL_FO, "footnote");
                Element footnoteBody = doc.createElementNS(XSL_FO, "footnote-body");
                ret.appendChild(footnoteBody);
                Element block = doc.createElementNS(XSL_FO, "block");
                footnoteBody.appendChild(block);
                this.setBorders(block);
                XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)block);
                return ret;
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "TODO (how did we get here?) mso-position-vertical-relative=" + mso_position_vertical_relative);
        }
        return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float capable renderer, support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
    }
}

