/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class AbstractEndpointHandlerMapping<E extends MvcEndpoint>
extends RequestMappingHandlerMapping {
    private final Set<E> endpoints;
    private HandlerInterceptor securityInterceptor;
    private final CorsConfiguration corsConfiguration;
    private String prefix = "";
    private boolean disabled = false;

    public AbstractEndpointHandlerMapping(Collection<? extends E> endpoints) {
        this(endpoints, null);
    }

    public AbstractEndpointHandlerMapping(Collection<? extends E> endpoints, CorsConfiguration corsConfiguration) {
        this.endpoints = new HashSet<E>(endpoints);
        this.postProcessEndpoints(this.endpoints);
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
        this.setUseSuffixPatternMatch(false);
    }

    protected void postProcessEndpoints(Set<E> endpoints) {
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.disabled) {
            for (MvcEndpoint endpoint : this.endpoints) {
                this.detectHandlerMethods(endpoint);
            }
        }
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    @Deprecated
    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        if (mapping == null) {
            return;
        }
        Object[] patterns = this.getPatterns(handler, mapping);
        if (!ObjectUtils.isEmpty((Object[])patterns)) {
            super.registerHandlerMethod(handler, method, (Object)this.withNewPatterns(mapping, (String[])patterns));
        }
    }

    private String[] getPatterns(Object handler, RequestMappingInfo mapping) {
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        Assert.state((boolean)(handler instanceof MvcEndpoint), (String)"Only MvcEndpoints are supported");
        String path = this.getPath((MvcEndpoint)handler);
        return path != null ? this.getEndpointPatterns(path, mapping) : null;
    }

    protected String getPath(MvcEndpoint endpoint) {
        return endpoint.getPath();
    }

    private String[] getEndpointPatterns(String path, RequestMappingInfo mapping) {
        String patternPrefix = StringUtils.hasText((String)this.prefix) ? this.prefix + path : path;
        Set defaultPatterns = mapping.getPatternsCondition().getPatterns();
        if (defaultPatterns.isEmpty()) {
            return new String[]{patternPrefix, patternPrefix + ".json"};
        }
        ArrayList<String> patterns = new ArrayList<String>(defaultPatterns);
        for (int i = 0; i < patterns.size(); ++i) {
            patterns.set(i, patternPrefix + (String)patterns.get(i));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private RequestMappingInfo withNewPatterns(RequestMappingInfo mapping, String[] patternStrings) {
        PatternsRequestCondition patterns = new PatternsRequestCondition(patternStrings, null, null, this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), null);
        return new RequestMappingInfo(patterns, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }

    protected HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        HandlerExecutionChain chain = super.getHandlerExecutionChain(handler, request);
        if (this.securityInterceptor == null || CorsUtils.isCorsRequest((HttpServletRequest)request)) {
            return chain;
        }
        return this.addSecurityInterceptor(chain);
    }

    protected HandlerExecutionChain getCorsHandlerExecutionChain(HttpServletRequest request, HandlerExecutionChain chain, CorsConfiguration config) {
        chain = super.getCorsHandlerExecutionChain(request, chain, config);
        if (this.securityInterceptor == null) {
            return chain;
        }
        return this.addSecurityInterceptor(chain);
    }

    protected void extendInterceptors(List<Object> interceptors) {
        interceptors.add((Object)new SkipPathExtensionContentNegotiation());
    }

    private HandlerExecutionChain addSecurityInterceptor(HandlerExecutionChain chain) {
        ArrayList<HandlerInterceptor> interceptors = new ArrayList<HandlerInterceptor>();
        if (chain.getInterceptors() != null) {
            interceptors.addAll(Arrays.asList(chain.getInterceptors()));
        }
        interceptors.add(this.securityInterceptor);
        return new HandlerExecutionChain(chain.getHandler(), interceptors.toArray(new HandlerInterceptor[interceptors.size()]));
    }

    public void setSecurityInterceptor(HandlerInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public void setPrefix(String prefix) {
        Assert.isTrue(("".equals(prefix) || StringUtils.startsWithIgnoreCase((String)prefix, (String)"/") ? 1 : 0) != 0, (String)"prefix must start with '/'");
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath(String endpoint) {
        return this.prefix + endpoint;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Set<E> getEndpoints() {
        return Collections.unmodifiableSet(this.endpoints);
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        return this.corsConfiguration;
    }

    private static final class SkipPathExtensionContentNegotiation
    extends HandlerInterceptorAdapter {
        private static final String SKIP_ATTRIBUTE = PathExtensionContentNegotiationStrategy.class.getName() + ".SKIP";

        private SkipPathExtensionContentNegotiation() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            request.setAttribute(SKIP_ATTRIBUTE, (Object)Boolean.TRUE);
            return true;
        }
    }
}

