/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class MissingCheckConstraintChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (CheckConstraint.class.isAssignableFrom(clazz)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, Column.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        if (((CheckConstraint)(databaseObject = (CheckConstraint)databaseObject)).getTable() == null) {
            return null;
        }
        object = new AddCheckConstraintChange();
        ((AddCheckConstraintChange)object).setTableName(((CheckConstraint)databaseObject).getTable().getName());
        if (diffOutputControl.getIncludeCatalog()) {
            ((AddCheckConstraintChange)object).setCatalogName(((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((AddCheckConstraintChange)object).setSchemaName(((CheckConstraint)databaseObject).getTable().getSchema().getName());
        }
        ((AddCheckConstraintChange)object).setConstraintName(((CheckConstraint)databaseObject).getName());
        ((AddCheckConstraintChange)object).setConstraintBody(((CheckConstraint)databaseObject).getBody());
        ((AddCheckConstraintChange)object).setDisabled(((CheckConstraint)databaseObject).isDisabled());
        if (!((CheckConstraint)databaseObject).isValidate()) {
            ((AddCheckConstraintChange)object).setValidate(((CheckConstraint)databaseObject).isValidate());
        }
        return new Change[]{object};
    }
}

