/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.condition;

import java.util.Map;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean enabledByDefault;
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnEnabledEndpoint.class.getName()));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.determineEndpointOutcome(endpointName, enabledByDefault = annotationAttributes.getBoolean("enabledByDefault"), context);
        if (outcome != null) {
            return outcome;
        }
        return this.determineAllEndpointsOutcome(context);
    }

    private ConditionOutcome determineEndpointOutcome(String endpointName, boolean enabledByDefault, ConditionContext context) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "endpoints." + endpointName + ".");
        if (resolver.containsProperty("enabled") || !enabledByDefault) {
            boolean match = (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)enabledByDefault);
            ConditionMessage message = ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[]{"(" + endpointName + ")"}).because(match ? "enabled" : "disabled");
            return new ConditionOutcome(match, message);
        }
        return null;
    }

    private ConditionOutcome determineAllEndpointsOutcome(ConditionContext context) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "endpoints.");
        boolean match = Boolean.valueOf(resolver.getProperty("enabled", "true"));
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("All endpoints are " + (match ? "enabled" : "disabled") + " by default");
        return new ConditionOutcome(match, message);
    }
}

