/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleChangeSetFilter;
import com.datical.liquibase.ext.command.RollbackOneChangeSetCommand$1;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.license.LicenseServiceFactory;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class RollbackOneChangeSetCommand
extends AbstractSelfConfiguratingCommand {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private String changeLogFilePath;
    private Writer outputWriter;
    private Liquibase liquibase;
    private Boolean force;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private boolean ignoreClasspathPrefix;
    private String rollbackScript;
    private ResourceAccessor resourceAccessor;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;
    private Logger log = LogService.getLog(this.getClass());

    @Override
    public int getPriority(String string) {
        if (!LicenseServiceFactory.getInstance().getLicenseService().licenseIsValid("Liquibase Pro")) {
            return -1;
        }
        return super.getPriority(string);
    }

    @Override
    public String getName() {
        return "rollbackOneChangeSet";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void configure(Map object) {
        if (object.containsKey("help")) {
            if (object.containsKey("outputWriter")) {
                System.out.println("liquibase <global parameters> rollbackOneChangeSetSQL --changeSetId=<id> --changeSetAuthor=<author> --changeSetPath=<filepath> [--rollbackScript=<path/to/SQLscript>] --force\n\nrollbackOneChangeSetSQL          Displays the SQL which will be executed when the corresponding rollbackOneChangeSet command is executed, and does\n                                 not perform the actual rollback. (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --changeLogFile          is the root changelog - liquibase will check it and any of its nested \n                                 changelogs for the definitions of the changeSets to roll back\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database passwor     */d\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --changeSetId            is the changeset id from the changelog\n    --changeSetAuthor        is the name of the author for the changeset id\n    --changeSetPath          is the path to the changelog containing the changeset to be rolled back\n");
            } else {
                System.out.println("liquibase <global parameters> rollbackOneChangeSet --changeSetId=<id> --changeSetAuthor=<author> --changeSetPath=<filepath> [--rollbackScript=<path/to/SQLscript>] --force\n\nrollbackOneChangeset          Rolls back one specific changeset, without rolling back changesets deployed before or afterwards. (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --changeLogFile          is the root changelog - liquibase will check it and any of its nested \n                                 changelogs for the definitions of the changeSets to roll back\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --changeSetId            is the changeset id from the changelog\n    --changeSetAuthor        is the name of the author for the changeset id\n    --changeSetPath          is the path to the changelog containing the changeset to be rolled back\n    --force                  is required to make sure you intended to run this operation\n    [--rollbackScript]       is the path to the script to use to perform tbe rollback\n                                 This option is only needed if the rollback is not already defined in\n                                 the changelog, and if it is not a rollback that is automatically\n                                 provided by liquibase.");
            }
            System.exit(0);
        }
        this.changeSetId = (String)object.get("changeSetId");
        this.changeSetAuthor = (String)object.get("changeSetAuthor");
        this.changeSetPath = (String)object.get("changeSetPath");
        this.rollbackScript = (String)object.get("rollbackScript");
        this.database = (Database)object.get("database");
        this.changeLog = (DatabaseChangeLog)object.get("changeLog");
        this.resourceAccessor = (ResourceAccessor)object.get("resourceAccessor");
        this.changeLogFilePath = (String)object.get("changeLogFile");
        this.changeLogParameters = (ChangeLogParameters)object.get("changeLogParameters");
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(String.format(coreBundle.getString("id.author.path.required"), new Object[0]));
        }
        this.force = (Boolean)object.get("force");
        if (this.force == null || !this.force.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollbackOneChangeSetSQL'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.liquibase = (Liquibase)object.get("liquibase");
        this.outputWriter = (Writer)object.get("outputWriter");
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new RollbackOneChangeSetCommand$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    @Override
    protected CommandResult run() {
        Object object;
        Executor executor = null;
        if (this.outputWriter != null) {
            executor = ExecutorService.getInstance().getExecutor("jdbc", this.database);
            object = new LoggingExecutor(executor, this.outputWriter, this.database);
            ExecutorService.getInstance().setExecutor("jdbc", this.database, (Executor)object);
            ExecutorService.getInstance().setExecutor("logging", this.database, (Executor)object);
        } else {
            object = new LoggingExecutor(null, null, this.database);
        }
        ExecutorService.getInstance().setExecutor("logging", this.database, (Executor)object);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            this.changeLog.setIgnoreClasspathPrefix(false);
            Object object2 = this.database.getRanChangeSetList();
            SingleChangeSetFilter singleChangeSetFilter = new SingleChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, (List<RanChangeSet>)object2, this.changeLog);
            if (singleChangeSetFilter.isEmpty()) {
                object2 = "rollbackOneChangeSet";
                if (this.outputWriter != null) {
                    object2 = "rollbackOneChangeSetSQL";
                }
                object = this.changeSetPath + "::" + this.changeSetId + "::" + this.changeSetAuthor;
                object = "\n\nWARNING:  The command '" + (String)object2 + "' failed because the targeted change set '" + (String)object + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.  Please check your details and try again.";
                if (singleChangeSetFilter.getMatchingIdChangeSet() != null) {
                    object = (String)object + "\nNOTE:  A change set with this ID was located.  ";
                }
                object = (String)object + "Please check your parameters.  No rollback was performed.";
                throw new LiquibaseException((String)object);
            }
            object = this.getChangeSetString();
            this.liquibase.outputHeader("Rollback changeset '" + (String)object + "'");
            object2 = this.createChangeLogIterator((List<RanChangeSet>)object2, singleChangeSetFilter);
            if (this.rollbackScript == null) {
                ((ChangeLogIterator)object2).run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
            } else {
                RollbackOneChangeSetCommand rollbackOneChangeSetCommand = this;
                rollbackOneChangeSetCommand.executeRollbackScript(rollbackOneChangeSetCommand.rollbackScript, (String)object, this.contexts, this.labelExpression);
                this.removeRunStatus((ChangeLogIterator)object2, this.contexts, this.labelExpression);
                this.log.info("Executed rollback script " + this.rollbackScript);
            }
        }
        catch (RollbackFailedException rollbackFailedException) {
            object = this.getChangeSetString();
            Throwable throwable = rollbackFailedException.getCause();
            if (throwable != null && throwable instanceof RollbackImpossibleException) {
                LogService.getLog(this.getClass()).severe(LogType.LOG, "\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", rollbackFailedException);
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, rollbackFailedException);
                }
                throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", rollbackFailedException);
            }
            LogService.getLog(this.getClass()).severe(LogType.LOG, "\nError executing rollback for the targeted changeset '" + (String)object + "'.");
            if (this.changeExecListener != null) {
                this.changeExecListener.runFailed(null, this.changeLog, this.database, rollbackFailedException);
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + rollbackFailedException.getMessage(), rollbackFailedException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                this.log.severe(LogType.LOG, MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (executor != null) {
                ExecutorService.getInstance().setExecutor("jdbc", this.database, executor);
            }
        }
        this.resetServices();
        return new CommandResult("rollbackOneChangeSet executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getChangeSetString() {
        ChangeSet changeSet = this.changeLog.getChangeSet(this.changeSetPath, this.changeSetAuthor, this.changeSetId);
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list, this.ignoreClasspathPrefix), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void executeRollbackScript(String string, String string2, Contexts contexts, LabelExpression labelExpression) {
        Object object;
        Executor executor = ExecutorService.getInstance().getExecutor("jdbc", this.database);
        try {
            object = this.resourceAccessor.getResourcesAsStream(string);
            if (object == null || object.isEmpty()) {
                throw new LiquibaseException("WARNING: The rollback script '" + string + "' was not located. Please check your parameters. No rollback was performed.");
            }
            if (object.size() > 1) {
                throw new LiquibaseException("Found multiple rollbackScripts named ".concat(String.valueOf(string)));
            }
            string = StreamUtil.getStreamContents(object.iterator().next());
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + iOException.getMessage());
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        string = this.changeLogParameters.expandExpressions(string, this.changeLog);
        object = this.buildRawSQLChange(string);
        try {
            LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, "Rolling Back Changeset:".concat(String.valueOf(string2)));
            executor.execute((Change)object);
        }
        catch (DatabaseException databaseException) {
            LogService.getLog(this.getClass()).severe(LogType.LOG, "Error executing rollback script: " + databaseException.getMessage());
            if (this.changeExecListener != null) {
                this.changeExecListener.runFailed(null, this.changeLog, this.database, databaseException);
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + string2 + "':\n" + databaseException.getMessage(), databaseException);
        }
        this.database.commit();
        if (string.length() == 0) {
            LogService.getLog(this.getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    protected RawSQLChange buildRawSQLChange(String object) {
        object = new RawSQLChange((String)object);
        ((AbstractSQLChange)object).setSplitStatements(Boolean.TRUE);
        ((AbstractSQLChange)object).setStripComments(Boolean.TRUE);
        return object;
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        ExecutorService.getInstance().reset();
    }
}

