/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grails.gsp.compiler.Reverse;

class Strip {
    private static Pattern stripTag = Pattern.compile("\\^([a-zA-Z]+)%\\{([^}]|\\}[^%])*\\}%");
    private static Pattern anyTag = Pattern.compile("((\\^[a-zA-Z])?%\\{([^}]|\\}[^%])*\\}%|[$@]\\{[^}]*\\})");
    private StringBuilder text;

    Strip(CharSequence text) {
        this.text = new StringBuilder(text.toString());
    }

    void strip(int index) {
        Matcher match = stripTag.matcher(this.text);
        if (match.find(index)) {
            Pattern patBefore;
            Matcher matchBefore;
            this.strip(match.end());
            String tag = match.group(1);
            int start = match.start() + 1 + tag.length();
            int end = match.end();
            Pattern patAfter = Pattern.compile("</" + tag + "(>|[^>a-zA-Z][^>]*>)\\s*", 2);
            Matcher matchAfter = patAfter.matcher(this.text);
            if (matchAfter.find(end)) {
                Pattern nextTagPat;
                Matcher matchNext;
                int end2 = matchAfter.end();
                Matcher matchAny = anyTag.matcher(this.text.subSequence(0, end2));
                if (matchAny.find(end)) {
                    end2 = matchAny.start();
                }
                if ((matchNext = (nextTagPat = Pattern.compile("<" + tag + "(\\s|>)", 2)).matcher(this.text.subSequence(0, end2))).find(end)) {
                    end2 = matchNext.start();
                }
                this.text.delete(end, end2);
            }
            if ((matchBefore = (patBefore = Pattern.compile(new Reverse("*s\\<" + tag).toString(), 2)).matcher(new Reverse(this.text, 0, start))).find()) {
                int start2 = start - matchBefore.end();
                Matcher matchAny = anyTag.matcher(this.text.subSequence(0, start));
                if (matchAny.find(start2)) {
                    start2 = matchAny.end();
                }
                this.text.delete(start2, start);
            }
        }
    }

    public String toString() {
        return this.text.toString();
    }
}

