/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.CellRefGenerator;
import org.jxls.command.Command;
import org.jxls.command.DynamicSheetNameGenerator;
import org.jxls.command.SheetNameGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.GroupData;
import org.jxls.common.JxlsException;
import org.jxls.common.Size;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.util.JxlsHelper;
import org.jxls.util.OrderByComparator;
import org.jxls.util.UtilWrapper;

public class EachCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "each";
    static final String GROUP_DATA_KEY = "_group";
    private UtilWrapper util = new UtilWrapper();
    private String items;
    private String var;
    private String varIndex;
    private Direction direction = Direction.DOWN;
    private String select;
    private String groupBy;
    private String groupOrder;
    private String orderBy;
    private String multisheet;
    private CellRefGenerator cellRefGenerator;
    private Area area;

    public EachCommand() {
    }

    public EachCommand(String var, String items, Direction direction) {
        this.var = var;
        this.items = items;
        this.direction = direction == null ? Direction.DOWN : direction;
    }

    public EachCommand(String items, Area area) {
        this(null, items, area);
    }

    public EachCommand(String var, String items, Area area) {
        this(var, items, area, Direction.DOWN);
    }

    public EachCommand(String var, String items, Area area, Direction direction) {
        this(var, items, direction);
        if (area != null) {
            this.area = area;
            this.addArea(this.area);
        }
    }

    public EachCommand(String var, String items, Area area, CellRefGenerator cellRefGenerator) {
        this(var, items, area, (Direction)null);
        this.cellRefGenerator = cellRefGenerator;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    UtilWrapper getUtil() {
        return this.util;
    }

    void setUtil(UtilWrapper util) {
        this.util = util;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVarIndex() {
        return this.varIndex;
    }

    public void setVarIndex(String varIndex) {
        this.varIndex = varIndex;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setDirection(String direction) {
        this.direction = Direction.valueOf(direction);
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupOrder() {
        return this.groupOrder;
    }

    public void setGroupOrder(String groupOrder) {
        this.groupOrder = groupOrder;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getMultisheet() {
        return this.multisheet;
    }

    public void setMultisheet(String multisheet) {
        this.multisheet = multisheet;
    }

    public CellRefGenerator getCellRefGenerator() {
        return this.cellRefGenerator;
    }

    public void setCellRefGenerator(CellRefGenerator cellRefGenerator) {
        this.cellRefGenerator = cellRefGenerator;
    }

    @Override
    public Command addArea(Area area) {
        if (area == null) {
            return this;
        }
        if (this.areaList.size() >= 1) {
            throw new IllegalArgumentException("You can add only a single area to 'each' command");
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        Size size;
        Iterable<Object> itemsCollection = null;
        try {
            itemsCollection = this.util.transformToIterableObject(this.getTransformationConfig().getExpressionEvaluator(), this.items, context);
            this.orderCollection(itemsCollection);
        }
        catch (Exception e) {
            this.getTransformer().getExceptionHandler().handleEvaluationException(e, cellRef.toString(), this.items);
            itemsCollection = Collections.emptyList();
        }
        if (this.groupBy == null || this.groupBy.length() == 0) {
            size = this.processCollection(context, itemsCollection, cellRef, this.var);
        } else {
            Collection<GroupData> groupedData = this.util.groupIterable(itemsCollection, this.groupBy, this.groupOrder);
            String groupVar = this.var != null ? this.var : GROUP_DATA_KEY;
            size = this.processCollection(context, groupedData, cellRef, groupVar);
        }
        if (this.direction == Direction.DOWN) {
            this.getTransformer().adjustTableSize(cellRef, size);
        }
        return size;
    }

    private void orderCollection(Iterable<?> itemsCollection) {
        if (itemsCollection instanceof List && this.orderBy != null && !this.orderBy.trim().isEmpty()) {
            List<String> orderByProps = Arrays.asList(this.orderBy.split(",")).stream().map(f -> this.removeVarPrefix(f.trim())).collect(Collectors.toList());
            OrderByComparator comp = new OrderByComparator(orderByProps, this.util);
            Collections.sort((List)itemsCollection, comp);
        }
    }

    private Size processCollection(Context context, Iterable<?> itemsCollection, CellRef cellRef, String varName) {
        int index = 0;
        int newWidth = 0;
        int newHeight = 0;
        CellRefGenerator cellRefGenerator = this.cellRefGenerator;
        if (cellRefGenerator == null && this.multisheet != null) {
            List<String> sheetNameList = this.extractSheetNameList(context);
            cellRefGenerator = sheetNameList == null ? new DynamicSheetNameGenerator(this.multisheet, cellRef, this.getTransformationConfig().getExpressionEvaluator()) : new SheetNameGenerator(sheetNameList, cellRef);
        }
        ExpressionEvaluator selectEvaluator = null;
        if (this.select != null) {
            selectEvaluator = JxlsHelper.getInstance().createExpressionEvaluator(this.select);
        }
        CellRef currentCell = cellRef;
        Object currentVarObject = varName == null ? null : context.getRunVar(varName);
        Object currentVarIndexObject = this.varIndex == null ? null : context.getRunVar(this.varIndex);
        int currentIndex = 0;
        for (Object obj : itemsCollection) {
            Size size;
            context.putVar(varName, obj);
            if (this.varIndex != null) {
                context.putVar(this.varIndex, currentIndex);
            }
            if (selectEvaluator != null && !this.util.isConditionTrue(selectEvaluator, context).booleanValue()) {
                context.removeVar(varName);
                continue;
            }
            if (cellRefGenerator != null) {
                currentCell = cellRefGenerator.generateCellRef(index++, context);
            }
            if (currentCell == null) break;
            try {
                size = this.area.applyAt(currentCell, context);
            }
            catch (NegativeArraySizeException e) {
                throw new JxlsException("Check jx:each/lastCell parameter in template! Illegal area: " + this.area.getAreaRef(), e);
            }
            if (cellRefGenerator != null) {
                newWidth = Math.max(newWidth, size.getWidth());
                newHeight = Math.max(newHeight, size.getHeight());
            } else if (this.direction == Direction.DOWN) {
                currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow() + size.getHeight(), currentCell.getCol());
                newWidth = Math.max(newWidth, size.getWidth());
                newHeight += size.getHeight();
            } else {
                currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
                newWidth += size.getWidth();
                newHeight = Math.max(newHeight, size.getHeight());
            }
            ++currentIndex;
        }
        this.restoreVarObject(context, this.varIndex, currentVarIndexObject);
        this.restoreVarObject(context, varName, currentVarObject);
        return new Size(newWidth, newHeight);
    }

    private void restoreVarObject(Context context, String varName, Object varObject) {
        if (varName == null) {
            return;
        }
        if (varObject != null) {
            context.putVar(varName, varObject);
        } else {
            context.removeVar(varName);
        }
    }

    private List<String> extractSheetNameList(Context context) {
        try {
            Object sheetnames = context.getVar(this.multisheet);
            if (sheetnames == null) {
                return null;
            }
            if (sheetnames instanceof List) {
                return (List)sheetnames;
            }
        }
        catch (Exception e) {
            throw new JxlsException("Failed to get sheet names from " + this.multisheet, e);
        }
        throw new JxlsException("The sheet names var '" + this.multisheet + "' must be of type List<String>.");
    }

    private String removeVarPrefix(String pVariable) {
        String pre;
        int o = pVariable.indexOf(".");
        if (o >= 0 && (pre = pVariable.substring(0, o).trim()).equals(this.var)) {
            return pVariable.substring(o + 1).trim();
        }
        return pVariable;
    }

    public static enum Direction {
        RIGHT,
        DOWN;

    }
}

