/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageChange;
import com.datical.liquibase.ext.storedlogic.function.Function;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class MissingPackageChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (DatabasePackage.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Function.class, StoredProcedure.class};
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        object = new CreatePackageChange();
        if (diffOutputControl.getIncludeCatalog()) {
            ((CreateProcedureChange)object).setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((CreateProcedureChange)object).setSchemaName(databaseObject.getSchema().getName());
        }
        ((CreatePackageChange)object).setPackageName(databaseObject.getName());
        ((CreatePackageChange)object).setPackageText(((StoredDatabaseLogic)databaseObject).getBody());
        return new Change[]{object};
    }
}

