/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.Formatter;
import org.jadira.usertype.dateandtime.shared.spi.AbstractTimestampColumnMapper;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.TimeOfDay;

public class TimestampColumnTimeOfDayMapper
extends AbstractTimestampColumnMapper<TimeOfDay> {
    private static final long serialVersionUID = 1921591625617366103L;

    public TimeOfDay fromNonNullString(String s) {
        return new TimeOfDay((Object)s);
    }

    public TimeOfDay fromNonNullValue(Timestamp value) {
        LocalTime localTime = Formatter.LOCAL_DATETIME_PARSER.parseDateTime(value.toString()).toLocalTime();
        TimeOfDay timeOfDay = new TimeOfDay(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), localTime.getChronology());
        return timeOfDay;
    }

    public String toNonNullString(TimeOfDay value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(TimeOfDay value) {
        String formattedTimestamp = Formatter.LOCAL_DATETIME_PRINTER.print((ReadablePartial)value.toLocalTime());
        if (formattedTimestamp.endsWith(".")) {
            formattedTimestamp = formattedTimestamp.substring(0, formattedTimestamp.length() - 1);
        }
        Timestamp timestamp = Timestamp.valueOf(formattedTimestamp);
        return timestamp;
    }
}

