/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.FieldExtractor;
import java.util.ArrayList;
import java.util.List;

public class FieldsExtractor<T extends FieldExtractor> {
    private static final String XDOCREPORT_FIELD_SUFFIX = "___";
    private List<T> fields = new ArrayList<T>();
    private final boolean ignoreXDocReportField;

    public FieldsExtractor() {
        this(true);
    }

    public FieldsExtractor(boolean ignoreXDocReportField) {
        this.ignoreXDocReportField = ignoreXDocReportField;
    }

    public T addFieldName(String fieldName, boolean list) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        for (FieldExtractor field : this.fields) {
            if (!fieldName.equals(field.getName())) continue;
            return null;
        }
        if (this.ignoreXDocReportField && fieldName.startsWith(XDOCREPORT_FIELD_SUFFIX)) {
            return null;
        }
        T field = this.createField(fieldName, list);
        if (field != null) {
            this.fields.add(field);
        }
        return field;
    }

    public List<T> getFields() {
        return this.fields;
    }

    protected T createField(String fieldName, boolean list) {
        return (T)new FieldExtractor(fieldName, list);
    }

    public static FieldsExtractor<FieldExtractor> create() {
        return new FieldsExtractor<FieldExtractor>();
    }
}

