/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RollbackContainer;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.logging.LogService;
import liquibase.logging.LogType;

public class RollbackVisitor
implements ChangeSetVisitor {
    private Database database;
    private ChangeExecListener execListener;

    @Deprecated
    public RollbackVisitor(Database database) {
        this.database = database;
    }

    public RollbackVisitor(Database database, ChangeExecListener listener) {
        this(database);
        this.execListener = listener;
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.REVERSE;
    }

    @Override
    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        if (!(executor instanceof LoggingExecutor)) {
            LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, "Rolling Back Changeset:" + changeSet);
        }
        changeSet.rollback(this.database, this.execListener);
        this.database.removeRanStatus(changeSet);
        this.sendRollbackEvent(changeSet, databaseChangeLog, database);
        this.database.commit();
        this.checkForEmptyRollbackFile(changeSet);
    }

    private void checkForEmptyRollbackFile(ChangeSet changeSet) {
        RollbackContainer container = changeSet.getRollback();
        List<Change> changes = container.getChanges();
        if (changes.isEmpty()) {
            return;
        }
        for (Change change : changes) {
            String sql;
            if (!(change instanceof SQLFileChange) || (sql = ((SQLFileChange)change).getSql()).length() != 0) continue;
            LogService.getLog(this.getClass()).info("\nNo rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    private void sendRollbackEvent(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database2) {
        if (this.execListener != null) {
            this.execListener.rolledBack(changeSet, databaseChangeLog, this.database);
        }
    }
}

