/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.IOException;
import java.io.InputStream;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeLogParameters;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

@DatabaseChange(name="sqlFile", description="The 'sqlFile' tag allows you to specify any sql statements and have it stored external in a file. It is useful for complex changes that are not supported through Liquibase's automated refactoring tags such as stored procedures.\n\nThe sqlFile refactoring finds the file by searching in the following order:\n\nThe file is searched for in the classpath. This can be manually set and by default the Liquibase startup script adds the current directory when run.\nThe file is searched for using the file attribute as a file name. This allows absolute paths to be used or relative paths to the working directory to be used.\nThe 'sqlFile' tag can also support multiline statements in the same file. Statements can either be split using a ; at the end of the last line of the SQL or a go on its own on the line between the statements can be used.Multiline SQL statements are also supported and only a ; or go statement will finish a statement, a new line is not enough. Files containing a single statement do not need to use a ; or go.\n\nThe sql file can also contain comments of either of the following formats:\n\nA multiline comment that starts with /* and ends with */.\nA single line comment starting with <space>--<space> and finishing at the end of the line", priority=1)
public class SQLFileChange
extends AbstractSQLChange {
    private String path;
    private Boolean relativeToChangelogFile;

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return false;
    }

    @DatabaseChangeProperty(description="The file path of the SQL file to load", exampleValue="my/path/file.sql", requiredForDatabase={"all"})
    public String getPath() {
        return this.path;
    }

    public void setPath(String fileName) {
        this.path = fileName;
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @Override
    public void finishInitialization() throws SetupException {
        if (this.path == null) {
            throw new SetupException("<sqlfile> - No path specified");
        }
    }

    @Override
    public InputStream openSqlStream() throws IOException {
        if (this.path == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = StreamUtil.openStream(this.path, this.isRelativeToChangelogFile(), this.getChangeSet(), this.getResourceAccessor());
        }
        catch (IOException e2) {
            throw new IOException("Unable to read file '" + this.path + "'", e2);
        }
        if (inputStream == null) {
            throw new IOException("File does not exist: '" + this.path + "'");
        }
        return inputStream;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtils.trimToNull(this.getPath()) == null) {
            validationErrors.addError("'path' is required");
        }
        return validationErrors;
    }

    @Override
    public String getConfirmationMessage() {
        return "SQL in file " + this.path + " executed";
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getSql() {
        String sql = super.getSql();
        if (sql == null) {
            try {
                ChangeLogParameters parameters;
                InputStream sqlStream = this.openSqlStream();
                if (sqlStream == null) {
                    return null;
                }
                String content = StreamUtil.getStreamContents(sqlStream, this.encoding);
                if (this.getChangeSet() != null && (parameters = this.getChangeSet().getChangeLogParameters()) != null) {
                    content = parameters.expandExpressions(content, this.getChangeSet().getChangeLog());
                }
                return content;
            }
            catch (IOException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        }
        return sql;
    }

    @Override
    public void setSql(String sql) {
        if (this.getChangeSet() != null && this.getChangeSet().getChangeLogParameters() != null) {
            sql = this.getChangeSet().getChangeLogParameters().expandExpressions(sql, this.getChangeSet().getChangeLog());
        }
        super.setSql(sql);
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

