/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.migration.AbstractMigratorUsingAnswersFormat;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromVariableReplacement
extends AbstractMigratorUsingAnswersFormat {
    private static Logger log = LoggerFactory.getLogger(FromVariableReplacement.class);

    public WordprocessingMLPackage migrate(WordprocessingMLPackage pkgIn) throws Exception {
        WordprocessingMLPackage pkgOut = (WordprocessingMLPackage)pkgIn.clone();
        VariablePrepare.prepare(pkgOut);
        this.createParts(pkgOut);
        PFinder pFinder = new PFinder();
        new TraversalUtil(pkgOut.getMainDocumentPart().getContent(), pFinder);
        for (P p : pFinder.pList) {
            ArrayList<Object> replacementContent = new ArrayList<Object>();
            for (Object o : p.getContent()) {
                if ((o = XmlUtils.unwrap(o)) instanceof R) {
                    for (Object o2 : ((R)o).getContent()) {
                        Object o3 = XmlUtils.unwrap(o2);
                        if (o3 instanceof Text) {
                            this.handle((R)o, ((Text)o3).getValue(), 0, replacementContent);
                            continue;
                        }
                        R rnew = new R();
                        rnew.setRPr(((R)o).getRPr());
                        rnew.getContent().add(o2);
                        replacementContent.add(rnew);
                    }
                    continue;
                }
                replacementContent.add(o);
            }
            p.getContent().clear();
            p.getContent().addAll(replacementContent);
        }
        return pkgOut;
    }

    private void handle(R r, String s, int offset, List<Object> replacementContent) {
        int startKey = s.indexOf("${", offset);
        if (startKey == -1) {
            this.addTextRun(r, s.substring(offset), replacementContent);
            return;
        }
        this.addTextRun(r, s.substring(offset, startKey), replacementContent);
        int keyEnd = s.indexOf(125, startKey);
        String key = s.substring(startKey + 2, keyEnd);
        this.createContentControl(r.getRPr(), replacementContent, key);
        this.handle(r, s, keyEnd + 1, replacementContent);
    }

    private void addTextRun(R r, String val, List<Object> replacementContent) {
        R rnew = new R();
        rnew.setRPr(r.getRPr());
        Text text = Context.getWmlObjectFactory().createText();
        text.setValue(val);
        if (val.startsWith(" ") || val.endsWith(" ")) {
            text.setSpace("preserve");
        }
        rnew.getContent().add(text);
        replacementContent.add(rnew);
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/unmarshallFromTemplateExample.docx";
        String outputfilepath = System.getProperty("user.dir") + "/OUT_VariableReplace.docx";
        WordprocessingMLPackage pkgIn = WordprocessingMLPackage.load(new File(inputfilepath));
        FromVariableReplacement migrator = new FromVariableReplacement();
        WordprocessingMLPackage pkgOut = migrator.migrate(pkgIn);
        SaveToZipFile saver = new SaveToZipFile(pkgOut);
        saver.save(outputfilepath);
    }

    static class PFinder
    extends TraversalUtil.CallbackImpl {
        List<P> pList = new ArrayList<P>();

        PFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P) {
                this.pList.add((P)o);
            }
            return null;
        }
    }
}

